/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.RecordProcessor;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeCountsProcessor
implements RecordProcessor<NodeRecord> {
    private final NodeStore nodeStore;
    private final long[] labelCounts;
    private final NodeLabelsCache cache;
    private final CountsAccessor.Updater counts;
    private final int anyLabel;
    private final NodeLabelsCache.Client cacheClient;

    NodeCountsProcessor(NodeStore nodeStore, NodeLabelsCache cache, int highLabelId, CountsAccessor.Updater counts) {
        this.nodeStore = nodeStore;
        this.cache = cache;
        this.anyLabel = highLabelId;
        this.counts = counts;
        this.labelCounts = new long[highLabelId + 1];
        this.cacheClient = cache.newClient();
    }

    @Override
    public boolean process(NodeRecord node, PageCursorTracer cursorTracer) {
        long[] labels = NodeLabelsField.get(node, this.nodeStore, cursorTracer);
        if (labels.length > 0) {
            for (long labelId : labels) {
                int n = (int)labelId;
                this.labelCounts[n] = this.labelCounts[n] + 1L;
            }
            this.cache.put(this.cacheClient, node.getId(), labels);
        }
        int n = this.anyLabel;
        this.labelCounts[n] = this.labelCounts[n] + 1L;
        return false;
    }

    @Override
    public void mergeResultsFrom(RecordProcessor<NodeRecord> other) {
        NodeCountsProcessor o = (NodeCountsProcessor)other;
        for (int i = 0; i < o.labelCounts.length; ++i) {
            int n = i;
            this.labelCounts[n] = this.labelCounts[n] + o.labelCounts[i];
        }
    }

    @Override
    public void done() {
        for (int i = 0; i < this.labelCounts.length; ++i) {
            this.counts.incrementNodeCount(i == this.anyLabel ? -1L : (long)i, this.labelCounts[i]);
        }
    }

    @Override
    public void close() {
    }
}

