/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.NodeSetFirstGroupStep;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.store.StorePrepareIdSequence;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class NodeFirstGroupStage
extends Stage {
    public static final String NAME = "Node --> Group";

    NodeFirstGroupStage(Configuration config, RecordStore<RelationshipGroupRecord> groupStore, NodeStore nodeStore, ByteArray cache, PageCacheTracer pageCacheTracer) {
        super(NAME, null, config, 0);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.allIn(groupStore, config), groupStore.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipGroupRecord>(this.control(), config, true, groupStore, pageCacheTracer));
        this.add(new NodeSetFirstGroupStep(this.control(), config, nodeStore, cache, pageCacheTracer));
        this.add(new UpdateRecordsStep<NodeRecord>(this.control(), config, nodeStore, new StorePrepareIdSequence(), pageCacheTracer));
    }
}

