/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.PropertyValueLookup;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class NodeInputIdPropertyLookup
implements PropertyValueLookup {
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;

    NodeInputIdPropertyLookup(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
        this.propertyRecord = propertyStore.newRecord();
    }

    public Object lookupProperty(long nodeId, PageCursorTracer cursorTracer) {
        this.propertyStore.getRecord(nodeId, this.propertyRecord, RecordLoad.CHECK, cursorTracer);
        if (!this.propertyRecord.inUse()) {
            return null;
        }
        return this.propertyRecord.iterator().next().newPropertyValue(this.propertyStore, cursorTracer).asObject();
    }
}

