/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class NodeSetFirstGroupStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private static final String SET_FIRST_GROUP_STEP_TAG = "setFirstGroupStep";
    private final int batchSize;
    private final ByteArray cache;
    private final NodeStore nodeStore;
    private final PageCursor nodeCursor;
    private final PageCursorTracer cursorTracer;
    private NodeRecord[] current;
    private int cursor;

    NodeSetFirstGroupStep(StageControl control, Configuration config, NodeStore nodeStore, ByteArray cache, PageCacheTracer pageCacheTracer) {
        super(control, "FIRST", config, 1, pageCacheTracer, new StatsProvider[0]);
        this.cache = cache;
        this.batchSize = config.batchSize();
        this.nodeStore = nodeStore;
        this.cursorTracer = pageCacheTracer.createPageCursorTracer(SET_FIRST_GROUP_STEP_TAG);
        this.nodeCursor = nodeStore.openPageCursorForReading(0L, this.cursorTracer);
        this.newBatch();
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
    }

    private void newBatch() {
        this.current = new NodeRecord[this.batchSize];
        this.cursor = 0;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        for (RelationshipGroupRecord group : batch) {
            long nodeId;
            if (!group.inUse() || this.cache.getByte(nodeId = group.getOwningNode(), 0) != 0) continue;
            this.cache.setByte(nodeId, 0, (byte)1);
            NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
            this.nodeStore.getRecordByCursor(nodeId, nodeRecord, RecordLoad.NORMAL, this.nodeCursor);
            nodeRecord.setNextRel(group.getId());
            nodeRecord.setDense(true);
            this.current[this.cursor++] = nodeRecord;
            if (this.cursor != this.batchSize) continue;
            sender.send(this.current);
            this.newBatch();
        }
        this.control.recycle(batch);
    }

    @Override
    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
        if (this.cursor > 0) {
            sender.send(this.current);
        }
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.cursorTracer});
        super.close();
    }
}

