/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.MetadataProvider;

public class ParallelBatchImporter
implements BatchImporter {
    private static final String BATCH_IMPORTER_CHECKPOINT = "Batch importer checkpoint.";
    private final PageCache externalPageCache;
    private final DatabaseLayout databaseLayout;
    private final FileSystemAbstraction fileSystem;
    private final PageCacheTracer pageCacheTracer;
    private final Configuration config;
    private final LogService logService;
    private final Config dbConfig;
    private final RecordFormats recordFormats;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final ImportLogic.Monitor monitor;
    private final JobScheduler jobScheduler;
    private final Collector badCollector;
    private final LogFilesInitializer logFilesInitializer;
    private final MemoryTracker memoryTracker;

    public ParallelBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache externalPageCache, PageCacheTracer pageCacheTracer, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, ImportLogic.Monitor monitor, JobScheduler jobScheduler, Collector badCollector, LogFilesInitializer logFilesInitializer, MemoryTracker memoryTracker) {
        this.externalPageCache = externalPageCache;
        this.databaseLayout = databaseLayout;
        this.fileSystem = fileSystem;
        this.pageCacheTracer = pageCacheTracer;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
        this.monitor = monitor;
        this.jobScheduler = jobScheduler;
        this.badCollector = badCollector;
        this.logFilesInitializer = logFilesInitializer;
        this.memoryTracker = memoryTracker;
    }

    public void doImport(Input input) throws IOException {
        try (BatchingNeoStores store = ImportLogic.instantiateNeoStores(this.fileSystem, this.databaseLayout, this.externalPageCache, this.pageCacheTracer, this.recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig, this.jobScheduler, this.memoryTracker);
             ImportLogic logic = new ImportLogic(this.databaseLayout, store, this.config, this.dbConfig, this.logService, this.executionMonitor, this.recordFormats, this.badCollector, this.monitor, this.pageCacheTracer, this.memoryTracker);){
            store.createNew();
            logic.initialize(input);
            logic.importNodes();
            logic.prepareIdMapper();
            logic.importRelationships();
            logic.calculateNodeDegrees();
            logic.linkRelationshipsOfAllTypes();
            logic.defragmentRelationshipGroups();
            logic.buildCountsStore();
            this.logFilesInitializer.initializeLogFiles(this.databaseLayout, (MetadataProvider)store.getNeoStores().getMetaDataStore(), this.fileSystem, BATCH_IMPORTER_CHECKPOINT);
            logic.success();
        }
    }
}

