/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.RelationshipCountsProcessor;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;

public class ProcessRelationshipCountsDataStep
extends RecordProcessorStep<RelationshipRecord> {
    public ProcessRelationshipCountsDataStep(StageControl control, NodeLabelsCache cache, Configuration config, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        super(control, "COUNT", config, () -> new RelationshipCountsProcessor(cache, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, memoryTracker), true, ProcessRelationshipCountsDataStep.numberOfProcessors(config, cache, highLabelId, highRelationshipTypeId), pageCacheTracer, new StatsProvider[0]);
    }

    private static int numberOfProcessors(Configuration config, NodeLabelsCache cache, int highLabelId, int highRelationshipTypeId) {
        GatheringMemoryStatsVisitor memVisitor = new GatheringMemoryStatsVisitor();
        cache.acceptMemoryStatsVisitor((MemoryStatsVisitor)memVisitor);
        long availableMem = config.maxMemoryUsage() - memVisitor.getTotalUsage();
        long threadMem = RelationshipCountsProcessor.calculateMemoryUsage(highLabelId, highRelationshipTypeId);
        long possibleThreads = availableMem / threadMem;
        return possibleThreads >= (long)config.maxNumberOfProcessors() ? 0 : Math.toIntExact(Math.max(1L, possibleThreads));
    }
}

