/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Supplier;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.ProducerStep;
import org.neo4j.internal.batchimport.staging.RecordDataAssembler;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class ReadGroupRecordsByCacheStep
extends ProducerStep {
    private static final String READ_RELATIONSHIP_GROUPS_STEP_TAG = "readRelationshipGroupsStep";
    private final RecordStore<RelationshipGroupRecord> store;
    private final NodeRelationshipCache cache;
    private final PageCacheTracer pageCacheTracer;

    public ReadGroupRecordsByCacheStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, NodeRelationshipCache cache, PageCacheTracer pageCacheTracer) {
        super(control, config);
        this.store = store;
        this.cache = cache;
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    protected void process() {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(READ_RELATIONSHIP_GROUPS_STEP_TAG);
             NodeVisitor visitor = new NodeVisitor(cursorTracer);){
            this.cache.visitChangedNodes((NodeRelationshipCache.NodeChangeVisitor)visitor, 1);
        }
    }

    @Override
    protected long position() {
        return this.store.getHighId() * (long)this.store.getRecordSize();
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable,
    NodeRelationshipCache.GroupVisitor,
    Supplier<RelationshipGroupRecord[]> {
        private final RecordDataAssembler<RelationshipGroupRecord> assembler = new RecordDataAssembler<RelationshipGroupRecord>(ReadGroupRecordsByCacheStep.this.store::newRecord, false);
        private final PageCursorTracer cursorTracer;
        private RelationshipGroupRecord[] batch = this.get();
        private int cursor;
        private long time = System.nanoTime();

        NodeVisitor(PageCursorTracer cursorTracer) {
            this.cursorTracer = cursorTracer;
        }

        public void change(long nodeId, ByteArray array) {
            ReadGroupRecordsByCacheStep.this.cache.getFirstRel(nodeId, (NodeRelationshipCache.GroupVisitor)this);
        }

        public long visit(long nodeId, int typeId, long out, long in, long loop) {
            long id = ReadGroupRecordsByCacheStep.this.store.nextId(this.cursorTracer);
            RelationshipGroupRecord record = this.batch[this.cursor++];
            record.setId(id);
            record.initialize(true, typeId, out, in, loop, nodeId, loop);
            if (this.cursor == ReadGroupRecordsByCacheStep.this.batchSize) {
                this.send();
                this.batch = ReadGroupRecordsByCacheStep.this.control.reuse(this);
                this.cursor = 0;
            }
            return id;
        }

        private void send() {
            ReadGroupRecordsByCacheStep.this.totalProcessingTime.add(System.nanoTime() - this.time);
            ReadGroupRecordsByCacheStep.this.sendDownstream(this.batch);
            this.time = System.nanoTime();
            ReadGroupRecordsByCacheStep.this.assertHealthy();
        }

        @Override
        public void close() {
            if (this.cursor > 0) {
                this.batch = (RelationshipGroupRecord[])this.assembler.cutOffAt(this.batch, this.cursor);
                this.send();
            }
        }

        @Override
        public RelationshipGroupRecord[] get() {
            return (RelationshipGroupRecord[])this.assembler.newBatchObject(ReadGroupRecordsByCacheStep.this.batchSize);
        }
    }
}

