/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordProcessor;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class RecordProcessorStep<T extends AbstractBaseRecord>
extends ProcessorStep<T[]> {
    private final Supplier<RecordProcessor<T>> processorFactory;
    private final boolean endOfLine;
    private final List<RecordProcessor<T>> allProcessors = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<RecordProcessor<T>> threadProcessors = new ThreadLocal<RecordProcessor<T>>(){

        @Override
        protected RecordProcessor<T> initialValue() {
            RecordProcessor processor = RecordProcessorStep.this.processorFactory.get();
            RecordProcessorStep.this.allProcessors.add(processor);
            return processor;
        }
    };

    public RecordProcessorStep(StageControl control, String name, Configuration config, Supplier<RecordProcessor<T>> processorFactory, boolean endOfLine, int maxProcessors, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProviders) {
        super(control, name, config, maxProcessors, pageCacheTracer, additionalStatsProviders);
        this.processorFactory = processorFactory;
        this.endOfLine = endOfLine;
    }

    @Override
    protected void process(T[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        RecordProcessor<T> processor = this.threadProcessors.get();
        for (T item : batch) {
            if (item == null || !((AbstractBaseRecord)item).inUse() || processor.process(item, cursorTracer)) continue;
            ((AbstractBaseRecord)item).setInUse(false);
        }
        if (!this.endOfLine) {
            sender.send(batch);
        }
    }

    @Override
    protected void done() {
        super.done();
        Iterator<RecordProcessor<T>> processors = this.allProcessors.iterator();
        if (processors.hasNext()) {
            RecordProcessor<T> first = processors.next();
            while (processors.hasNext()) {
                first.mergeResultsFrom(processors.next());
            }
            first.done();
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        IOUtils.closeAll(this.allProcessors);
    }
}

