/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.RecordProcessor;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;

public class RelationshipCountsProcessor
implements RecordProcessor<RelationshipRecord> {
    private final LongArray labelsCounts;
    private final LongArray wildcardCounts;
    private final CountsAccessor.Updater countsUpdater;
    private final long anyLabel;
    private final long anyRelationshipType;
    private final RelationshipCounter counter;

    public RelationshipCountsProcessor(NodeLabelsCache nodeLabelCache, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, MemoryTracker memoryTracker) {
        this.countsUpdater = countsUpdater;
        this.anyLabel = highLabelId;
        this.anyRelationshipType = highRelationshipTypeId;
        this.labelsCounts = cacheFactory.newLongArray(RelationshipCounter.labelsCountsLength(highLabelId, highRelationshipTypeId), 0L, memoryTracker);
        this.wildcardCounts = cacheFactory.newLongArray(RelationshipCounter.wildcardCountsLength(highRelationshipTypeId), 0L, memoryTracker);
        NodeLabelsCache.Client nodeLabelsClient = nodeLabelCache.newClient();
        RelationshipCounter.NodeLabelsLookup nodeLabelLookup = nodeId -> nodeLabelCache.get(nodeLabelsClient, nodeId);
        this.counter = new RelationshipCounter(nodeLabelLookup, highLabelId, highRelationshipTypeId, this.wildcardCounts, this.labelsCounts, RelationshipCounter.MANUAL_INCREMENTER);
    }

    static long calculateMemoryUsage(int highLabelId, int highRelationshipTypeId) {
        long labelsCountsUsage = RelationshipCounter.labelsCountsLength(highLabelId, highRelationshipTypeId) * 8L;
        long wildcardCountsUsage = RelationshipCounter.wildcardCountsLength(highRelationshipTypeId) * 8L;
        return labelsCountsUsage + wildcardCountsUsage;
    }

    @Override
    public boolean process(RelationshipRecord record, PageCursorTracer cursorTracer) {
        this.counter.process(record);
        return false;
    }

    @Override
    public void done() {
        int wildcardType = 0;
        while ((long)wildcardType <= this.anyRelationshipType) {
            int type = (long)wildcardType == this.anyRelationshipType ? -1 : wildcardType;
            long count = this.wildcardCounts.get((long)wildcardType);
            this.countsUpdater.incrementRelationshipCount(-1L, type, -1L, count);
            ++wildcardType;
        }
        int labelId = 0;
        while ((long)labelId < this.anyLabel) {
            int typeId = 0;
            while ((long)typeId <= this.anyRelationshipType) {
                long startCount = this.counter.startLabelCount(labelId, typeId);
                long endCount = this.counter.endLabelCount(labelId, typeId);
                int type = (long)typeId == this.anyRelationshipType ? -1 : typeId;
                this.countsUpdater.incrementRelationshipCount((long)labelId, type, -1L, startCount);
                this.countsUpdater.incrementRelationshipCount(-1L, type, (long)labelId, endCount);
                ++typeId;
            }
            ++labelId;
        }
    }

    @Override
    public void mergeResultsFrom(RecordProcessor<RelationshipRecord> other) {
        RelationshipCountsProcessor o = (RelationshipCountsProcessor)other;
        this.mergeCounts(this.labelsCounts, o.labelsCounts);
        this.mergeCounts(this.wildcardCounts, o.wildcardCounts);
    }

    @Override
    public void close() {
        this.labelsCounts.close();
        this.wildcardCounts.close();
    }

    private void mergeCounts(LongArray destination, LongArray part) {
        long length = destination.length();
        for (long i = 0L; i < length; ++i) {
            destination.set(i, destination.get(i) + part.get(i));
        }
    }
}

