/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ProcessRelationshipCountsDataStep;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;

public class RelationshipCountsStage
extends Stage {
    public static final String NAME = "Relationship counts";

    public RelationshipCountsStage(Configuration config, NodeLabelsCache cache, RelationshipStore relationshipStore, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, ProgressReporter progressReporter, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        super(NAME, null, config, 2);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.withProgressReport(RecordIdIterator.allIn(relationshipStore, config), progressReporter), relationshipStore.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipRecord>(this.control(), config, false, relationshipStore, pageCacheTracer));
        this.add(new ProcessRelationshipCountsDataStep(this.control(), cache, config, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, pageCacheTracer, memoryTracker));
    }
}

