/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.CountGroupsStage;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeFirstGroupStage;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.ScanAndCacheGroupsStage;
import org.neo4j.internal.batchimport.WriteGroupsStage;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;

public class RelationshipGroupDefragmenter {
    private final Configuration config;
    private final ExecutionMonitor executionMonitor;
    private final Monitor monitor;
    private final NumberArrayFactory numberArrayFactory;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;

    public RelationshipGroupDefragmenter(Configuration config, ExecutionMonitor executionMonitor, Monitor monitor, NumberArrayFactory numberArrayFactory, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.config = config;
        this.executionMonitor = executionMonitor;
        this.monitor = monitor;
        this.numberArrayFactory = numberArrayFactory;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
    }

    public void run(long memoryWeCanHoldForCertain, BatchingNeoStores neoStore, long highNodeId) {
        try (RelationshipGroupCache groupCache = new RelationshipGroupCache(this.numberArrayFactory, memoryWeCanHoldForCertain, highNodeId, this.memoryTracker);){
            RecordStore<RelationshipGroupRecord> fromStore = neoStore.getTemporaryRelationshipGroupStore();
            RelationshipGroupStore toStore = neoStore.getRelationshipGroupStore();
            Configuration groupConfig = Configuration.withBatchSize((Configuration)this.config, (int)neoStore.getRelationshipGroupStore().getRecordsPerPage());
            MemoryUsageStatsProvider memoryUsage = new MemoryUsageStatsProvider(neoStore, groupCache);
            this.executeStage(new CountGroupsStage(groupConfig, fromStore, groupCache, this.pageCacheTracer, memoryUsage));
            long fromNodeId = 0L;
            while (fromNodeId < highNodeId) {
                long toNodeId = groupCache.prepare(fromNodeId);
                this.monitor.defragmentingNodeRange(fromNodeId, toNodeId);
                this.executeStage(new ScanAndCacheGroupsStage(groupConfig, fromStore, groupCache, this.pageCacheTracer, memoryUsage));
                this.executeStage(new WriteGroupsStage(groupConfig, groupCache, toStore, this.pageCacheTracer));
                fromNodeId = toNodeId;
            }
            ByteArray groupCountCache = groupCache.getGroupCountCache();
            groupCountCache.clear();
            Configuration nodeConfig = Configuration.withBatchSize((Configuration)this.config, (int)neoStore.getNodeStore().getRecordsPerPage());
            this.executeStage(new NodeFirstGroupStage(nodeConfig, toStore, neoStore.getNodeStore(), groupCountCache, this.pageCacheTracer));
        }
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, stage);
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Monitor(){};

        default public void defragmentingNodeRange(long fromNodeId, long toNodeId) {
        }
    }
}

