/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Predicate;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.RelationshipLinkbackStep;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.RecordDataAssembler;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipLinkbackStage
extends Stage {
    public static final String NAME = "Relationship <-- Relationship";

    public RelationshipLinkbackStage(String topic, Configuration config, BatchingNeoStores stores, NodeRelationshipCache cache, Predicate<RelationshipRecord> readFilter, Predicate<RelationshipRecord> changeFilter, int nodeTypes, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProvider) {
        super(NAME, topic, config, 3);
        RelationshipStore store = stores.getRelationshipStore();
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.backwards(0L, store.getHighId(), config), store.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipRecord>(this.control(), config, true, store, new RecordDataAssembler<RelationshipRecord>(store::newRecord, readFilter, true), true, pageCacheTracer));
        this.add(new RelationshipLinkbackStep(this.control(), config, cache, changeFilter, nodeTypes, additionalStatsProvider));
        this.add(new UpdateRecordsStep<RelationshipRecord>(this.control(), config, store, PrepareIdSequence.of(stores.usesDoubleRelationshipRecordUnits()), pageCacheTracer));
    }
}

