/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.EntityTokenUpdate;

public class RelationshipTypeIndexWriterStep
extends ProcessorStep<RelationshipRecord[]> {
    private static final String INDEX_WRITE_STEP_TAG = "indexWriteStep";
    private final PageCursorTracer cursorTracer;
    private final TokenScanWriter writer;

    public RelationshipTypeIndexWriterStep(StageControl control, Configuration config, RelationshipTypeScanStore relationshipTypeIndex, PageCacheTracer pageCacheTracer) {
        super(control, "RELATIONSHIP TYPE INDEX", config, 1, pageCacheTracer, new StatsProvider[0]);
        this.cursorTracer = pageCacheTracer.createPageCursorTracer(INDEX_WRITE_STEP_TAG);
        this.writer = relationshipTypeIndex.newBulkAppendWriter(this.cursorTracer);
    }

    @Override
    protected void process(RelationshipRecord[] batch, BatchSender sender, PageCursorTracer cursorTracer) throws Throwable {
        for (RelationshipRecord relationship : batch) {
            if (!relationship.inUse()) continue;
            this.writer.write(EntityTokenUpdate.tokenChanges((long)relationship.getId(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{relationship.getType()}));
        }
        sender.send(batch);
    }

    @Override
    public void close() throws Exception {
        super.close();
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.writer, this.cursorTracer});
    }
}

