/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ReadNodeIdsByCacheStep;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.SparseNodeFirstRelationshipProcessor;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.StorePrepareIdSequence;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class SparseNodeFirstRelationshipStage
extends Stage {
    public static final String NAME = "Node --> Relationship";

    public SparseNodeFirstRelationshipStage(Configuration config, NodeStore nodeStore, NodeRelationshipCache cache, PageCacheTracer pageCacheTracer) {
        super(NAME, null, config, 3);
        this.add(new ReadNodeIdsByCacheStep(this.control(), config, cache, 2));
        this.add(new ReadRecordsStep<NodeRecord>(this.control(), config, true, nodeStore, pageCacheTracer));
        this.add(new RecordProcessorStep(this.control(), "LINK", config, () -> new SparseNodeFirstRelationshipProcessor(cache), false, 1, pageCacheTracer, new StatsProvider[0]));
        this.add(new UpdateRecordsStep<NodeRecord>(this.control(), config, nodeStore, new StorePrepareIdSequence(), pageCacheTracer));
    }
}

