/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Collection;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongFunction;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IoThroughputStat;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<RECORD[]>
implements StatsProvider {
    protected final RecordStore<RECORD> store;
    private final int recordSize;
    private final PrepareIdSequence prepareIdSequence;
    private final LongAdder recordsUpdated = new LongAdder();

    public UpdateRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, PrepareIdSequence prepareIdSequence, PageCacheTracer pageCacheTracer) {
        super(control, "v", config, config.parallelRecordWrites() ? 0 : 1, pageCacheTracer, new StatsProvider[0]);
        this.store = store;
        this.prepareIdSequence = prepareIdSequence;
        this.recordSize = store.getRecordSize();
    }

    @Override
    protected void process(RECORD[] batch, BatchSender sender, PageCursorTracer cursorTracer) {
        LongFunction idSequence = (LongFunction)this.prepareIdSequence.apply(this.store);
        int recordsUpdatedInThisBatch = 0;
        for (RECORD record : batch) {
            if (record == null || !((AbstractBaseRecord)record).inUse() || IdValidator.isReservedId((long)((AbstractBaseRecord)record).getId())) continue;
            this.store.prepareForCommit(record, (IdSequence)idSequence.apply(((AbstractBaseRecord)record).getId()), cursorTracer);
            this.store.updateRecord(record, IdUpdateListener.IGNORE, cursorTracer);
            ++recordsUpdatedInThisBatch;
        }
        this.recordsUpdated.add(recordsUpdatedInThisBatch);
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, (long)this.recordSize * this.recordsUpdated.sum()) : null;
    }

    @Override
    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

