/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.RecordDataAssembler;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<LongIterator> {
    private final RecordStore<RECORD> store;
    private final int batchSize;
    private final boolean prefetch;
    private final RecordDataAssembler<RECORD> assembler;

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, PageCacheTracer pageCacheTracer) {
        this(control, config, inRecordWritingStage, store, new RecordDataAssembler<AbstractBaseRecord>(store::newRecord, true), false, pageCacheTracer);
    }

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, RecordDataAssembler<RECORD> converter, boolean prefetch, PageCacheTracer pageCacheTracer) {
        super(control, ">", config, ReadRecordsStep.parallelReading(config, inRecordWritingStage) ? Integer.min(12, config.maxNumberOfProcessors()) : 1, pageCacheTracer, new StatsProvider[0]);
        this.store = store;
        this.assembler = converter;
        this.batchSize = config.batchSize();
        this.prefetch = prefetch;
    }

    private static boolean parallelReading(Configuration config, boolean inRecordWritingStage) {
        return inRecordWritingStage && config.highIO() || !inRecordWritingStage && config.parallelRecordReads();
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees | 1);
    }

    @Override
    protected void process(LongIterator idRange, BatchSender sender, PageCursorTracer cursorTracer) {
        if (!idRange.hasNext()) {
            return;
        }
        long id = idRange.next();
        AbstractBaseRecord[] batch = this.control.reuse(() -> this.assembler.newBatchObject(this.batchSize));
        int i = 0;
        try (PageCursor cursor = this.prefetch ? this.store.openPageCursorForReadingWithPrefetching(id, cursorTracer) : this.store.openPageCursorForReading(id, cursorTracer);){
            boolean hasNext = true;
            while (hasNext) {
                if (this.assembler.append(this.store, cursor, batch, id, i)) {
                    ++i;
                }
                if (!(hasNext = idRange.hasNext())) continue;
                id = idRange.next();
            }
        }
        sender.send(this.assembler.cutOffAt(batch, i));
    }
}

