/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Pair;

public class StageExecution
implements StageControl,
AutoCloseable {
    public static final PanicMonitor DEFAULT_PANIC_MONITOR = cause -> System.err.println("Critical error occurred! Shutting down the import...");
    private final String stageName;
    private final String part;
    private final Configuration config;
    private final Collection<Step<?>> pipeline;
    private final int orderingGuarantees;
    private volatile Throwable panic;
    private final boolean shouldRecycle;
    private final PanicMonitor panicMonitor;
    private final ConcurrentLinkedQueue<Object> recycled;

    public StageExecution(String stageName, String part, Configuration config, Collection<Step<?>> pipeline, int orderingGuarantees) {
        this(stageName, part, config, pipeline, orderingGuarantees, DEFAULT_PANIC_MONITOR);
    }

    public StageExecution(String stageName, String part, Configuration config, Collection<Step<?>> pipeline, int orderingGuarantees, PanicMonitor panicMonitor) {
        this.stageName = stageName;
        this.part = part;
        this.config = config;
        this.pipeline = pipeline;
        this.orderingGuarantees = orderingGuarantees;
        this.shouldRecycle = (orderingGuarantees & 2) != 0;
        this.panicMonitor = panicMonitor;
        this.recycled = this.shouldRecycle ? new ConcurrentLinkedQueue() : null;
    }

    public boolean stillExecuting() {
        for (Step<?> step : this.pipeline) {
            if (step.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void awaitCompletion() throws InterruptedException {
        for (Step<?> step : this.pipeline) {
            step.awaitCompleted();
        }
    }

    public void start() {
        for (Step<?> step : this.pipeline) {
            step.start(this.orderingGuarantees);
        }
    }

    public String getStageName() {
        return this.stageName;
    }

    public String name() {
        return this.stageName + (this.part != null ? this.part : "");
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterable<Step<?>> steps() {
        return this.pipeline;
    }

    public List<Pair<Step<?>, Float>> stepsOrderedBy(Key stat, boolean trueForAscending) {
        ArrayList steps = new ArrayList(this.pipeline);
        steps.sort((o1, o2) -> {
            long stat1 = o1.longStat(stat);
            long stat2 = o2.longStat(stat);
            return trueForAscending ? Long.compare(stat1, stat2) : Long.compare(stat2, stat1);
        });
        ArrayList result = new ArrayList();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps - 1; ++i) {
            Step current = (Step)steps.get(i);
            result.add(Pair.of((Object)current, (Object)Float.valueOf((float)current.longStat(stat) / (float)((Step)steps.get(i + 1)).longStat(stat))));
        }
        result.add(Pair.of((Object)((Step)steps.get(steps.size() - 1)), (Object)Float.valueOf(1.0f)));
        return result;
    }

    public int size() {
        return this.pipeline.size();
    }

    @Override
    public synchronized void panic(Throwable cause) {
        if (this.panic == null) {
            this.panicMonitor.receivedPanic(cause);
            this.panic = cause;
            for (Step<?> step : this.pipeline) {
                step.receivePanic(cause);
                step.endOfUpstream();
            }
        } else if (!this.panic.equals(cause)) {
            this.panic.addSuppressed(cause);
        }
    }

    @Override
    public void assertHealthy() {
        if (this.panic != null) {
            Exceptions.throwIfUnchecked((Throwable)this.panic);
            throw new RuntimeException(this.panic);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name() + "]";
    }

    @Override
    public void recycle(Object batch) {
        if (this.shouldRecycle) {
            this.recycled.offer(batch);
        }
    }

    @Override
    public <T> T reuse(Supplier<T> fallback) {
        Object result;
        if (this.shouldRecycle && (result = this.recycled.poll()) != null) {
            return (T)result;
        }
        return fallback.get();
    }

    @Override
    public void close() {
        if (this.shouldRecycle) {
            this.recycled.clear();
        }
    }

    static interface PanicMonitor {
        public void receivedPanic(Throwable var1);
    }
}

