/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Predicate;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.store.BatchingTokenRepository;
import org.neo4j.internal.batchimport.store.PageCacheFlusher;
import org.neo4j.internal.batchimport.store.io.IoTracer;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class BatchingNeoStores
implements AutoCloseable,
MemoryStatsVisitor.Visitable {
    private static final String BATCHING_STORE_CREATION_TAG = "batchingStoreCreation";
    private static final String BATCHING_STORE_SHUTDOWN_TAG = "batchingStoreShutdown";
    private static final String TEMP_STORE_NAME = "temp";
    static final long DOUBLE_RELATIONSHIP_RECORD_UNIT_THRESHOLD = 0x200000000L;
    private static final StoreType[] TEMP_STORE_TYPES = new StoreType[]{StoreType.RELATIONSHIP_GROUP, StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING};
    private final FileSystemAbstraction fileSystem;
    private final LogProvider logProvider;
    private final DatabaseLayout databaseLayout;
    private final DatabaseLayout temporaryDatabaseLayout;
    private final Config neo4jConfig;
    private final Configuration importConfiguration;
    private final PageCache pageCache;
    private final IoTracer ioTracer;
    private final RecordFormats recordFormats;
    private final AdditionalInitialIds initialIds;
    private final boolean externalPageCache;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IdGeneratorFactory tempIdGeneratorFactory;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private NeoStores neoStores;
    private NeoStores temporaryNeoStores;
    private BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private LifeSupport life = new LifeSupport();
    private LabelScanStore labelScanStore;
    private RelationshipTypeScanStore relationshipTypeScanStore;
    private PageCacheFlusher flusher;
    private boolean doubleRelationshipRecordUnits;
    private boolean successful;

    private BatchingNeoStores(FileSystemAbstraction fileSystem, PageCache pageCache, DatabaseLayout databaseLayout, RecordFormats recordFormats, Config neo4jConfig, Configuration importConfiguration, LogService logService, AdditionalInitialIds initialIds, boolean externalPageCache, IoTracer ioTracer, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.fileSystem = fileSystem;
        this.recordFormats = recordFormats;
        this.importConfiguration = importConfiguration;
        this.initialIds = initialIds;
        this.logProvider = logService.getInternalLogProvider();
        this.databaseLayout = databaseLayout;
        this.temporaryDatabaseLayout = DatabaseLayout.ofFlat((Path)databaseLayout.file(TEMP_STORE_NAME));
        this.neo4jConfig = neo4jConfig;
        this.pageCache = pageCache;
        this.ioTracer = ioTracer;
        this.externalPageCache = externalPageCache;
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate());
        this.tempIdGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate());
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
    }

    private boolean databaseExistsAndContainsData() {
        Path metaDataFile = this.databaseLayout.metadataStore();
        try {
            PagedFile pagedFile = this.pageCache.map(metaDataFile, this.pageCache.pageSize(), Sets.immutable.of((Object)StandardOpenOption.READ));
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        try (NeoStores stores = this.newStoreFactory(this.databaseLayout, this.idGeneratorFactory, this.pageCacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(StoreType.NODE, StoreType.RELATIONSHIP);){
            boolean bl = stores.getNodeStore().getHighId() > 0L || stores.getRelationshipStore().getHighId() > 0L;
            return bl;
        }
    }

    public void createNew() throws IOException {
        this.assertDatabaseIsEmptyOrNonExistent();
        this.fileSystem.deleteFile(this.databaseLayout.labelScanStore());
        this.deleteCountsStore();
        this.instantiateStores();
    }

    private void deleteCountsStore() {
        this.fileSystem.deleteFile(this.databaseLayout.countStore());
    }

    public void assertDatabaseIsEmptyOrNonExistent() {
        if (this.databaseExistsAndContainsData()) {
            throw new IllegalStateException(this.databaseLayout.databaseDirectory() + " already contains data, cannot do import here");
        }
    }

    public void pruneAndOpenExistingStore(Predicate<StoreType> mainStoresToKeep, Predicate<StoreType> tempStoresToKeep) throws IOException {
        this.deleteStoreFiles(this.temporaryDatabaseLayout, tempStoresToKeep);
        this.deleteStoreFiles(this.databaseLayout, mainStoresToKeep);
        this.instantiateStores();
    }

    private void deleteStoreFiles(DatabaseLayout databaseLayout, Predicate<StoreType> storesToKeep) {
        for (StoreType type : StoreType.values()) {
            if (storesToKeep.test(type)) continue;
            DatabaseFile databaseFile = type.getDatabaseFile();
            databaseLayout.allFiles(databaseFile).forEach(arg_0 -> ((FileSystemAbstraction)this.fileSystem).deleteFile(arg_0));
        }
    }

    private void instantiateExtensions() {
        this.life = new LifeSupport();
        this.life.start();
        this.labelScanStore = TokenScanStore.labelScanStore((PageCache)this.pageCache, (DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (FullStoreChangeStream)FullStoreChangeStream.EMPTY, (boolean)false, (Monitors)new Monitors(), (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.immediate(), (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)this.memoryTracker);
        this.life.add((Lifecycle)this.labelScanStore);
        this.relationshipTypeScanStore = TokenScanStore.toggledRelationshipTypeScanStore((PageCache)this.pageCache, (DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (FullStoreChangeStream)FullStoreChangeStream.EMPTY, (boolean)false, (Monitors)new Monitors(), (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.immediate(), (Config)this.neo4jConfig, (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)this.memoryTracker);
        this.life.add((Lifecycle)this.relationshipTypeScanStore);
    }

    private void instantiateStores() throws IOException {
        this.neoStores = this.newStoreFactory(this.databaseLayout, this.idGeneratorFactory, this.pageCacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openAllNeoStores(true);
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStores.getPropertyKeyTokenStore());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStores.getLabelTokenStore());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStores.getRelationshipTypeTokenStore());
        this.temporaryNeoStores = this.instantiateTempStores();
        this.instantiateExtensions();
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(BATCHING_STORE_CREATION_TAG);){
            this.neoStores.start(cursorTracer);
            this.temporaryNeoStores.start(cursorTracer);
            MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
            metaDataStore.setLastCommittedAndClosedTransactionId(this.initialIds.lastCommittedTransactionId(), this.initialIds.lastCommittedTransactionChecksum(), 0L, this.initialIds.lastCommittedTransactionLogByteOffset(), this.initialIds.lastCommittedTransactionLogVersion(), cursorTracer);
            metaDataStore.setCheckpointLogVersion(this.initialIds.checkpointLogVersion(), cursorTracer);
        }
    }

    private NeoStores instantiateTempStores() {
        return this.newStoreFactory(this.temporaryDatabaseLayout, this.tempIdGeneratorFactory, this.pageCacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(true, TEMP_STORE_TYPES);
    }

    public static BatchingNeoStores batchingNeoStores(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        PageCache pageCache = BatchingNeoStores.createPageCache(fileSystem, neo4jConfig, pageCacheTracer, jobScheduler, memoryTracker);
        return new BatchingNeoStores(fileSystem, pageCache, databaseLayout, recordFormats, neo4jConfig, config, logService, initialIds, false, () -> ((PageCacheTracer)pageCacheTracer).bytesWritten(), pageCacheTracer, memoryTracker);
    }

    public static BatchingNeoStores batchingNeoStoresWithExternalPageCache(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer tracer, DatabaseLayout databaseLayout, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig, MemoryTracker memoryTracker) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        return new BatchingNeoStores(fileSystem, pageCache, databaseLayout, recordFormats, neo4jConfig, config, logService, initialIds, true, () -> ((PageCacheTracer)tracer).bytesWritten(), tracer, memoryTracker);
    }

    private static Config getNeo4jConfig(Configuration config, Config dbConfig) {
        dbConfig.set(GraphDatabaseSettings.pagecache_memory, (Object)String.valueOf(config.pageCacheMemory()));
        return dbConfig;
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, PageCacheTracer tracer, JobScheduler jobScheduler, MemoryTracker memoryTracker) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(fileSystem);
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator((long)ByteUnit.parse((String)((String)config.get(GraphDatabaseSettings.pagecache_memory))), (MemoryTracker)memoryTracker);
        return new MuninnPageCache((PageSwapperFactory)swapperFactory, memoryAllocator, tracer, EmptyVersionContextSupplier.EMPTY, jobScheduler, Clocks.nanoClock(), memoryTracker, (IOBufferFactory)new ConfigurableIOBufferFactory(config, memoryTracker));
    }

    private StoreFactory newStoreFactory(DatabaseLayout databaseLayout, IdGeneratorFactory idGeneratorFactory, PageCacheTracer cacheTracer, ImmutableSet<OpenOption> openOptions) {
        return new StoreFactory(databaseLayout, this.neo4jConfig, idGeneratorFactory, this.pageCache, this.fileSystem, this.recordFormats, this.logProvider, cacheTracer, openOptions);
    }

    public RecordStore<RelationshipGroupRecord> getTemporaryRelationshipGroupStore() {
        return this.temporaryNeoStores.getRelationshipGroupStore();
    }

    public PropertyStore getTemporaryPropertyStore() {
        return this.temporaryNeoStores.getPropertyStore();
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStores.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStores.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStores.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStores.getRelationshipGroupStore();
    }

    public void buildCountsStore(CountsBuilder builder, PageCacheTracer cacheTracer, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.deleteCountsStore();
        try (GBPTreeCountsStore countsStore = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), builder, false, cacheTracer, GBPTreeCountsStore.NO_MONITOR);){
            countsStore.start(cursorTracer, memoryTracker);
            countsStore.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.markHighIds();
        if (this.flusher != null) {
            this.stopFlushingPageCache();
        }
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(BATCHING_STORE_SHUTDOWN_TAG);){
            this.flushAndForce(cursorTracer);
        }
        this.life.shutdown();
        IOUtils.closeAll((AutoCloseable[])new NeoStores[]{this.neoStores, this.temporaryNeoStores});
        if (!this.externalPageCache) {
            this.pageCache.close();
        }
        if (this.successful) {
            this.cleanup();
        }
    }

    public void markHighIds() {
        if (this.neoStores != null) {
            this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
        }
    }

    private void cleanup() throws IOException {
        Path tempDbDirectory = this.temporaryDatabaseLayout.databaseDirectory();
        if (!tempDbDirectory.getParent().equals(this.databaseLayout.databaseDirectory())) {
            throw new IllegalStateException("Temporary store is dislocated. It should be located under current database directory but instead located in: " + tempDbDirectory.getParent());
        }
        this.fileSystem.deleteRecursively(tempDbDirectory);
    }

    public long getLastCommittedTransactionId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public RelationshipTypeScanStore getRelationshipTypeScanStore() {
        return this.relationshipTypeScanStore;
    }

    public NeoStores getNeoStores() {
        return this.neoStores;
    }

    public void startFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher != null) {
                throw new IllegalStateException("Flusher already started");
            }
            this.flusher = new PageCacheFlusher(this.pageCache);
            this.flusher.start();
        }
    }

    public void stopFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher == null) {
                throw new IllegalStateException("Flusher not started");
            }
            this.flusher.halt();
            this.flusher = null;
        }
    }

    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.pageCache.maxCachedPages() * (long)this.pageCache.pageSize());
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public void flushAndForce(PageCursorTracer cursorTracer) throws IOException {
        if (this.propertyKeyRepository != null) {
            this.propertyKeyRepository.flush(cursorTracer);
        }
        if (this.labelRepository != null) {
            this.labelRepository.flush(cursorTracer);
        }
        if (this.relationshipTypeRepository != null) {
            this.relationshipTypeRepository.flush(cursorTracer);
        }
        if (this.neoStores != null) {
            this.neoStores.flush(IOLimiter.UNLIMITED, cursorTracer);
        }
        if (this.temporaryNeoStores != null) {
            this.temporaryNeoStores.flush(IOLimiter.UNLIMITED, cursorTracer);
        }
        if (this.labelScanStore != null) {
            this.labelScanStore.force(IOLimiter.UNLIMITED, cursorTracer);
        }
        if (this.relationshipTypeScanStore != null) {
            this.relationshipTypeScanStore.force(IOLimiter.UNLIMITED, cursorTracer);
        }
    }

    public void success() {
        this.successful = true;
    }

    public boolean determineDoubleRelationshipRecordUnits(Input.Estimates inputEstimates) {
        this.doubleRelationshipRecordUnits = this.recordFormats.hasCapability(RecordStorageCapability.SECONDARY_RECORD_UNITS) && inputEstimates.numberOfRelationships() > 0x200000000L;
        return this.doubleRelationshipRecordUnits;
    }

    public boolean usesDoubleRelationshipRecordUnits() {
        return this.doubleRelationshipRecordUnits;
    }
}

