/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store;

import java.util.function.LongFunction;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class SecondaryUnitPrepareIdSequence
implements PrepareIdSequence {
    @Override
    public LongFunction<IdSequence> apply(IdSequence idSequence) {
        return new NeighbourIdSequence();
    }

    private static class NeighbourIdSequence
    implements LongFunction<IdSequence>,
    IdSequence {
        private long id;
        private boolean returned;

        private NeighbourIdSequence() {
        }

        @Override
        public IdSequence apply(long firstUnitId) {
            this.id = firstUnitId;
            this.returned = false;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nextId(PageCursorTracer cursorTracer) {
            try {
                if (this.returned) {
                    throw new IllegalStateException("Already returned");
                }
                long l = this.id + 1L;
                return l;
            }
            finally {
                this.returned = true;
            }
        }
    }
}

