/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.concurrent.locks.Lock;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.counts.CountsKey;

class CountUpdater
implements CountsAccessor.Updater {
    private final CountWriter writer;
    private final Lock lock;

    CountUpdater(CountWriter writer, Lock lock) {
        this.writer = writer;
        this.lock = lock;
    }

    public void incrementNodeCount(long labelId, long delta) {
        this.writer.write(CountsKey.nodeKey(labelId), delta);
    }

    public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
        this.writer.write(CountsKey.relationshipKey(startLabelId, typeId, endLabelId), delta);
    }

    public void close() {
        try {
            this.writer.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface CountWriter
    extends AutoCloseable {
        public void write(CountsKey var1, long var2);

        @Override
        public void close();
    }
}

