/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.Objects;
import org.neo4j.counts.CountsVisitor;

public class CountsKey {
    static final int SIZE = 13;
    private static final byte TYPE_STRAY_TX_ID = 0;
    private static final byte TYPE_NODE = 1;
    private static final byte TYPE_RELATIONSHIP = 2;
    static final CountsKey MIN_COUNT = new CountsKey(1, Long.MIN_VALUE, Integer.MIN_VALUE);
    static final CountsKey MAX_COUNT = new CountsKey(2, Long.MAX_VALUE, Integer.MAX_VALUE);
    static final CountsKey MIN_STRAY_TX_ID = CountsKey.strayTxId(Long.MIN_VALUE);
    static final CountsKey MAX_STRAY_TX_ID = CountsKey.strayTxId(Long.MAX_VALUE);
    byte type;
    long first;
    int second;

    CountsKey() {
    }

    CountsKey(byte type, long keyFirst, int keySecond) {
        this.initialize(type, keyFirst, keySecond);
    }

    void initialize(byte type, long keyFirst, int keySecond) {
        this.type = type;
        this.first = keyFirst;
        this.second = keySecond;
    }

    public static CountsKey nodeKey(long labelId) {
        return new CountsKey(1, labelId, 0);
    }

    public static CountsKey relationshipKey(long startLabelId, long typeId, long endLabelId) {
        return new CountsKey(2, startLabelId << 32 | typeId & 0xFFFFFFFFL, (int)endLabelId);
    }

    static CountsKey strayTxId(long txId) {
        return new CountsKey(0, txId, 0);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.first, this.second);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CountsKey)) {
            return false;
        }
        CountsKey other = (CountsKey)obj;
        return this.type == other.type && this.first == other.first && this.second == other.second;
    }

    void accept(CountsVisitor visitor, long count) {
        switch (this.type) {
            case 1: {
                visitor.visitNodeCount((int)this.first, count);
                break;
            }
            case 2: {
                visitor.visitRelationshipCount(this.extractStartLabelId(), (int)this.first, this.second, count);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key type " + this.type);
            }
        }
    }

    private int extractStartLabelId() {
        return (int)(this.first >>> 32);
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return String.format("Node[label:%d]", this.first);
            }
            case 2: {
                return String.format("Relationship[startLabel:%d, type:%d, endLabel:%d]", this.extractStartLabelId(), (int)this.first, this.second);
            }
            case 0: {
                return String.format("Stray tx id:%d", this.first);
            }
        }
        return String.format("Unknown key type:%d, first:%d, second:%d", this.type, this.first, this.second);
    }
}

