/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongArrayQueue;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsHeader;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsLayout;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.internal.counts.MapWriter;
import org.neo4j.internal.counts.TreeWriter;
import org.neo4j.internal.counts.TxIdInformation;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class GBPTreeCountsStore
implements CountsStore {
    public static final Monitor NO_MONITOR = txId -> {};
    private static final long NEEDS_REBUILDING_HIGH_ID = 0L;
    private static final String OPEN_COUNT_STORE_TAG = "openCountStore";
    private final GBPTree<CountsKey, CountsValue> tree;
    private final OutOfOrderSequence idSequence;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final CountsLayout layout = new CountsLayout();
    private final CountsBuilder initialCountsBuilder;
    private final boolean readOnly;
    private final Monitor monitor;
    private volatile ConcurrentHashMap<CountsKey, AtomicLong> changes = new ConcurrentHashMap();
    private final TxIdInformation txIdInformation;
    private volatile boolean started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GBPTreeCountsStore(PageCache pageCache, Path file, FileSystemAbstraction fileSystem, RecoveryCleanupWorkCollector recoveryCollector, CountsBuilder initialCountsBuilder, boolean readOnly, PageCacheTracer pageCacheTracer, Monitor monitor) throws IOException {
        GBPTree<CountsKey, CountsValue> instantiatedTree;
        this.readOnly = readOnly;
        this.monitor = monitor;
        CountsHeader header = new CountsHeader(0L);
        try {
            instantiatedTree = this.instantiateTree(pageCache, file, recoveryCollector, readOnly, header, pageCacheTracer);
        }
        catch (MetadataMismatchException e) {
            fileSystem.deleteFileOrThrow(file);
            header = new CountsHeader(0L);
            instantiatedTree = this.instantiateTree(pageCache, file, recoveryCollector, readOnly, header, pageCacheTracer);
        }
        this.tree = instantiatedTree;
        boolean successful = false;
        try {
            try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(OPEN_COUNT_STORE_TAG);){
                this.txIdInformation = this.readTxIdInformation(header.highestGapFreeTxId(), cursorTracer);
                this.idSequence = new ArrayQueueOutOfOrderSequence(this.txIdInformation.highestGapFreeTxId, 200, PrimitiveLongCollections.EMPTY_LONG_ARRAY);
                this.txIdInformation.strayTxIds.forEach((LongProcedure & Serializable)txId -> this.idSequence.offer(txId, PrimitiveLongCollections.EMPTY_LONG_ARRAY));
                this.initialCountsBuilder = header.wasRead() && header.highestGapFreeTxId() != 0L ? null : initialCountsBuilder;
                successful = true;
            }
            if (successful) return;
        }
        catch (Throwable throwable) {
            if (successful) throw throwable;
            IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
    }

    private GBPTree<CountsKey, CountsValue> instantiateTree(PageCache pageCache, Path file, RecoveryCleanupWorkCollector recoveryCollector, boolean readOnly, CountsHeader header, PageCacheTracer pageCacheTracer) {
        try {
            return new GBPTree(pageCache, file, (Layout)this.layout, GBPTree.NO_MONITOR, (Header.Reader)header, (Consumer)header, recoveryCollector, readOnly, pageCacheTracer, Sets.immutable.empty(), "Counts store");
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Counts store file could not be found, most likely this database needs to be recovered, file:" + file, e);
        }
    }

    public void start(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws IOException {
        if (this.initialCountsBuilder != null) {
            if (this.readOnly) {
                throw new IllegalStateException("Counts store needs rebuilding, most likely this database needs to be recovered.");
            }
            Lock lock = GBPTreeCountsStore.lock(this.lock.writeLock());
            long txId = this.initialCountsBuilder.lastCommittedTxId();
            try (CountUpdater updater = new CountUpdater(new TreeWriter((Writer<CountsKey, CountsValue>)this.tree.writer(cursorTracer), this.idSequence, txId), lock);){
                this.initialCountsBuilder.initialize(updater, cursorTracer, memoryTracker);
            }
        }
        this.started = true;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
    }

    public CountsAccessor.Updater apply(long txId, PageCursorTracer cursorTracer) {
        boolean inRecoveryOnEmptyCountsStore;
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (String)"This counts store is read-only");
        Lock lock = GBPTreeCountsStore.lock(this.lock.readLock());
        boolean alreadyApplied = this.txIdInformation.txIdIsAlreadyApplied(txId);
        boolean bl = inRecoveryOnEmptyCountsStore = this.initialCountsBuilder != null && !this.started;
        if (alreadyApplied || inRecoveryOnEmptyCountsStore) {
            lock.unlock();
            this.monitor.ignoredTransaction(txId);
            return NO_OP_UPDATER;
        }
        return new CountUpdater(new MapWriter(key -> this.readCountFromTree((CountsKey)key, cursorTracer), this.changes, this.idSequence, txId), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(IOLimiter ioLimiter, PageCursorTracer cursorTracer) throws IOException {
        OutOfOrderSequence.Snapshot txIdSnapshot;
        if (this.readOnly) {
            return;
        }
        Lock writeLock = GBPTreeCountsStore.lock(this.lock.writeLock());
        try {
            txIdSnapshot = this.idSequence.snapshot();
            ConcurrentHashMap<CountsKey, AtomicLong> changesToWrite = this.changes;
            this.writeCountsChanges(changesToWrite, cursorTracer);
            this.changes = new ConcurrentHashMap();
        }
        finally {
            writeLock.unlock();
        }
        this.updateTxIdInformationInTree(txIdSnapshot, cursorTracer);
        this.tree.checkpoint(ioLimiter, (Consumer)new CountsHeader(txIdSnapshot.highestGapFree()[0]), cursorTracer);
    }

    private void writeCountsChanges(ConcurrentHashMap<CountsKey, AtomicLong> changes, PageCursorTracer cursorTracer) throws IOException {
        ArrayList<Map.Entry<CountsKey, AtomicLong>> changeList = new ArrayList<Map.Entry<CountsKey, AtomicLong>>(changes.entrySet());
        changeList.sort((e1, e2) -> this.layout.compare((CountsKey)e1.getKey(), (CountsKey)e2.getKey()));
        try (Writer writer = this.tree.writer(cursorTracer);){
            CountsValue value = new CountsValue();
            for (Map.Entry entry : changeList) {
                long count = ((AtomicLong)entry.getValue()).get();
                TreeWriter.merge((Writer<CountsKey, CountsValue>)writer, (CountsKey)entry.getKey(), value.initialize(count));
            }
        }
    }

    private void updateTxIdInformationInTree(OutOfOrderSequence.Snapshot txIdSnapshot, PageCursorTracer cursorTracer) throws IOException {
        PrimitiveLongArrayQueue strayIds = new PrimitiveLongArrayQueue();
        this.visitStrayTxIdsInTree(arg_0 -> ((PrimitiveLongArrayQueue)strayIds).enqueue(arg_0), cursorTracer);
        try (Writer writer = this.tree.writer(cursorTracer);){
            long[][] strayTxIds;
            CountsValue value = new CountsValue();
            while (!strayIds.isEmpty()) {
                long strayTxId = strayIds.dequeue();
                writer.remove((Object)CountsKey.strayTxId(strayTxId));
            }
            value.initialize(0L);
            for (long[] strayTxId : strayTxIds = txIdSnapshot.idsOutOfOrder()) {
                long txId = strayTxId[0];
                writer.put((Object)CountsKey.strayTxId(txId), (Object)value);
            }
        }
    }

    public long nodeCount(int labelId, PageCursorTracer cursorTracer) {
        return this.read(CountsKey.nodeKey(labelId), cursorTracer);
    }

    public long relationshipCount(int startLabelId, int typeId, int endLabelId, PageCursorTracer cursorTracer) {
        return this.read(CountsKey.relationshipKey(startLabelId, typeId, endLabelId), cursorTracer);
    }

    public void accept(CountsVisitor visitor, PageCursorTracer cursorTracer) {
        for (Map.Entry<CountsKey, AtomicLong> changedEntry : this.changes.entrySet()) {
            if (changedEntry.getValue().get() == 0L) continue;
            changedEntry.getKey().accept(visitor, changedEntry.getValue().get());
        }
        try (Seeker seek = this.tree.seek((Object)CountsKey.MIN_COUNT, (Object)CountsKey.MAX_COUNT, cursorTracer);){
            while (seek.next()) {
                CountsKey key = (CountsKey)seek.key();
                if (this.changes.containsKey(key)) continue;
                key.accept(visitor, ((CountsValue)seek.value()).count);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public long txId() {
        return this.idSequence.getHighestGapFreeNumber();
    }

    private long read(CountsKey key, PageCursorTracer cursorTracer) {
        AtomicLong changedCount = this.changes.get(key);
        return changedCount != null ? changedCount.get() : this.readCountFromTree(key, cursorTracer);
    }

    private long readCountFromTree(CountsKey key, PageCursorTracer cursorTracer) {
        long l;
        block8: {
            Seeker seek = this.tree.seek((Object)key, (Object)key, cursorTracer);
            try {
                long l2 = l = seek.next() ? ((CountsValue)seek.value()).count : 0L;
                if (seek == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (seek != null) {
                        try {
                            seek.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            seek.close();
        }
        return l;
    }

    private void visitStrayTxIdsInTree(LongConsumer visitor, PageCursorTracer cursorTracer) throws IOException {
        try (Seeker seek = this.tree.seek((Object)CountsKey.MIN_STRAY_TX_ID, (Object)CountsKey.MAX_STRAY_TX_ID, cursorTracer);){
            while (seek.next()) {
                visitor.accept(((CountsKey)seek.key()).first);
            }
        }
    }

    private TxIdInformation readTxIdInformation(long highestGapFreeTxId, PageCursorTracer cursorTracer) throws IOException {
        LongHashSet strayTxIds = new LongHashSet();
        this.visitStrayTxIdsInTree(arg_0 -> ((MutableLongSet)strayTxIds).add(arg_0), cursorTracer);
        return new TxIdInformation(highestGapFreeTxId, (LongSet)strayTxIds);
    }

    private static Lock lock(Lock lock) {
        lock.lock();
        return lock;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<CountsKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorTracer);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<CountsKey> visitor, PageCursorTracer cursorTracer) {
        try {
            return this.tree.consistencyCheck(visitor, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void dump(PageCache pageCache, Path file, final PrintStream out, PageCursorTracer cursorTracer) throws IOException {
        CountsHeader header = new CountsHeader(1L);
        GBPTree.readHeader((PageCache)pageCache, (Path)file, (Header.Reader)header, (PageCursorTracer)cursorTracer);
        try (GBPTree tree = new GBPTree(pageCache, file, (Layout)new CountsLayout(), GBPTree.NO_MONITOR, (Header.Reader)header, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.ignore(), true, PageCacheTracer.NULL, Sets.immutable.empty(), "Counts store");){
            out.printf("Highest gap-free txId: %d%n", header.highestGapFreeTxId());
            tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<CountsKey, CountsValue>(){
                private CountsKey key;

                public void key(CountsKey key, boolean isLeaf, long offloadId) {
                    this.key = key;
                }

                public void value(CountsValue value) {
                    out.printf("%s = %d%n", this.key, value.count);
                }
            }, cursorTracer);
        }
    }

    public static interface Monitor {
        public void ignoredTransaction(long var1);
    }
}

