/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class MapWriter
implements CountUpdater.CountWriter {
    private final ToLongFunction<CountsKey> storeLookup;
    private final ConcurrentMap<CountsKey, AtomicLong> changes;
    private final OutOfOrderSequence idSequence;
    private final long txId;

    MapWriter(ToLongFunction<CountsKey> storeLookup, ConcurrentMap<CountsKey, AtomicLong> changes, OutOfOrderSequence idSequence, long txId) {
        this.storeLookup = storeLookup;
        this.changes = changes;
        this.idSequence = idSequence;
        this.txId = txId;
    }

    @Override
    public void write(CountsKey key, long delta) {
        Function<CountsKey, AtomicLong> defaultToStoredCount = k -> new AtomicLong(this.storeLookup.applyAsLong((CountsKey)k));
        this.changes.computeIfAbsent(key, defaultToStoredCount).addAndGet(delta);
    }

    @Override
    public void close() {
        this.idSequence.offer(this.txId, ArrayUtils.EMPTY_LONG_ARRAY);
    }
}

