/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.io.IOUtils;
import org.neo4j.util.concurrent.OutOfOrderSequence;

class TreeWriter
implements CountUpdater.CountWriter {
    private static final ValueMerger<CountsKey, CountsValue> MERGER = (existingKey, newKey, existingValue, newValue) -> newValue.count > 0L ? ValueMerger.MergeResult.REPLACED : ValueMerger.MergeResult.REMOVED;
    private final Writer<CountsKey, CountsValue> treeWriter;
    private final OutOfOrderSequence idSequence;
    private final long txId;
    private final CountsValue value = new CountsValue();

    TreeWriter(Writer<CountsKey, CountsValue> treeWriter, OutOfOrderSequence idSequence, long txId) {
        this.treeWriter = treeWriter;
        this.idSequence = idSequence;
        this.txId = txId;
    }

    @Override
    public void write(CountsKey key, long delta) {
        TreeWriter.merge(this.treeWriter, key, this.value.initialize(delta));
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.treeWriter});
        this.idSequence.set(this.txId, ArrayUtils.EMPTY_LONG_ARRAY);
    }

    static void merge(Writer<CountsKey, CountsValue> writer, CountsKey key, CountsValue value) {
        if (value.count > 0L) {
            writer.merge((Object)key, (Object)value, MERGER);
        } else if (value.count == 0L) {
            writer.remove((Object)key);
        } else {
            throw new IllegalStateException("Count for " + key + " got negative: " + value.count);
        }
    }
}

