/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.IndexUpdates;
import org.neo4j.internal.recordstorage.IndexUpdatesWork;
import org.neo4j.internal.recordstorage.OnlineIndexUpdates;
import org.neo4j.internal.recordstorage.PropertyPhysicalToLogicalConverter;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.recordstorage.TokenUpdateWork;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.lock.LockGroup;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class BatchContext
implements AutoCloseable {
    private final WorkSync<EntityTokenUpdateListener, TokenUpdateWork> labelScanStoreSync;
    private final WorkSync<EntityTokenUpdateListener, TokenUpdateWork> relationshipTypeScanStoreSync;
    private final WorkSync<IndexUpdateListener, IndexUpdatesWork> indexUpdatesSync;
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final StorageEngine storageEngine;
    private final SchemaCache schemaCache;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;
    private final IdUpdateListener idUpdateListener;
    private final IndexActivator indexActivator;
    private final LockGroup lockGroup;
    private List<EntityTokenUpdate> labelUpdates;
    private List<EntityTokenUpdate> relationshipTypeUpdates;
    private IndexUpdates indexUpdates;

    public BatchContext(IndexUpdateListener indexUpdateListener, WorkSync<EntityTokenUpdateListener, TokenUpdateWork> labelScanStoreSync, WorkSync<EntityTokenUpdateListener, TokenUpdateWork> relationshipTypeScanStoreSync, WorkSync<IndexUpdateListener, IndexUpdatesWork> indexUpdatesSync, NodeStore nodeStore, PropertyStore propertyStore, RecordStorageEngine recordStorageEngine, SchemaCache schemaCache, PageCursorTracer cursorTracer, MemoryTracker memoryTracker, IdUpdateListener idUpdateListener) {
        this.indexActivator = new IndexActivator(indexUpdateListener);
        this.labelScanStoreSync = labelScanStoreSync;
        this.relationshipTypeScanStoreSync = relationshipTypeScanStoreSync;
        this.indexUpdatesSync = indexUpdatesSync;
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.storageEngine = recordStorageEngine;
        this.schemaCache = schemaCache;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
        this.idUpdateListener = idUpdateListener;
        this.lockGroup = new LockGroup();
    }

    public LockGroup getLockGroup() {
        return this.lockGroup;
    }

    @Override
    public void close() throws Exception {
        this.applyPendingLabelAndIndexUpdates();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.indexUpdates, this.idUpdateListener, this.lockGroup, this.indexActivator});
    }

    public IndexActivator getIndexActivator() {
        return this.indexActivator;
    }

    public void applyPendingLabelAndIndexUpdates() throws IOException {
        AsyncApply labelUpdatesApply = null;
        AsyncApply relationshipTypeUpdatesApply = null;
        if (this.labelUpdates != null) {
            labelUpdatesApply = this.labelScanStoreSync.applyAsync((Work)new TokenUpdateWork(this.labelUpdates, this.cursorTracer));
            this.labelUpdates = null;
        }
        if (this.relationshipTypeUpdates != null) {
            relationshipTypeUpdatesApply = this.relationshipTypeScanStoreSync.applyAsync((Work)new TokenUpdateWork(this.relationshipTypeUpdates, this.cursorTracer));
            this.relationshipTypeUpdates = null;
        }
        if (this.indexUpdates != null && this.indexUpdates.hasUpdates()) {
            try {
                this.indexUpdatesSync.apply((Work)new IndexUpdatesWork(this.indexUpdates, this.cursorTracer));
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush index updates", e);
            }
            this.indexUpdates = null;
        }
        if (labelUpdatesApply != null) {
            try {
                labelUpdatesApply.await();
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush label updates", e);
            }
        }
        if (relationshipTypeUpdatesApply != null) {
            try {
                relationshipTypeUpdatesApply.await();
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush relationship type updates", e);
            }
        }
    }

    public IndexUpdates indexUpdates() {
        if (this.indexUpdates == null) {
            this.indexUpdates = new OnlineIndexUpdates(this.nodeStore, this.schemaCache, new PropertyPhysicalToLogicalConverter(this.propertyStore, this.cursorTracer), this.storageEngine.newReader(), this.cursorTracer, this.memoryTracker);
        }
        return this.indexUpdates;
    }

    public IdUpdateListener getIdUpdateListener() {
        return this.idUpdateListener;
    }

    public List<EntityTokenUpdate> labelUpdates() {
        if (this.labelUpdates == null) {
            this.labelUpdates = new ArrayList<EntityTokenUpdate>();
        }
        return this.labelUpdates;
    }

    public List<EntityTokenUpdate> relationshipTypeUpdates() {
        if (this.relationshipTypeUpdates == null) {
            this.relationshipTypeUpdates = new ArrayList<EntityTokenUpdate>();
        }
        return this.relationshipTypeUpdates;
    }
}

