/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.token.api.NamedToken;

public class CacheInvalidationTransactionApplier
extends TransactionApplier.Adapter {
    private final CacheAccessBackDoor cacheAccess;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final LabelTokenStore labelTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final PageCursorTracer cursorTracer;

    public CacheInvalidationTransactionApplier(NeoStores neoStores, CacheAccessBackDoor cacheAccess, PageCursorTracer cursorTracer) {
        this.cacheAccess = cacheAccess;
        this.relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        this.labelTokenStore = neoStores.getLabelTokenStore();
        this.propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        this.cursorTracer = cursorTracer;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        NamedToken type = this.relationshipTypeTokenStore.getToken(command.tokenId(), this.cursorTracer);
        this.cacheAccess.addRelationshipTypeToken(type);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        NamedToken labelId = this.labelTokenStore.getToken(command.tokenId(), this.cursorTracer);
        this.cacheAccess.addLabelToken(labelId);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        NamedToken index = this.propertyKeyTokenStore.getToken(command.tokenId(), this.cursorTracer);
        this.cacheAccess.addPropertyKeyToken(index);
        return false;
    }

    @Override
    public void close() {
    }
}

