/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.BitSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.recordstorage.IdGeneratorUpdateWork;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

class ChangedIds {
    private final MutableLongList ids = LongLists.mutable.empty();
    private final BitSet usedSet = new BitSet();
    private AsyncApply asyncApply;

    ChangedIds() {
    }

    void addUsedId(long id) {
        this.usedSet.set(this.ids.size());
        this.ids.add(id);
    }

    void addUnusedId(long id) {
        this.ids.add(id);
    }

    void accept(IdGenerator.Marker visitor) {
        this.ids.forEachWithIndex((LongIntProcedure & Serializable)(id, index) -> {
            boolean used = this.usedSet.get(index);
            if (used) {
                visitor.markUsed(id);
            } else {
                visitor.markDeleted(id);
            }
        });
    }

    void applyAsync(WorkSync<IdGenerator, IdGeneratorUpdateWork> workSync, PageCacheTracer pageCacheTracer) {
        this.asyncApply = workSync.applyAsync((Work)new IdGeneratorUpdateWork(this, pageCacheTracer));
    }

    void awaitApply() throws ExecutionException {
        this.asyncApply.await();
    }
}

