/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.PropertyRecordChange;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.string.UTF8;
import org.neo4j.token.api.TokenIdPrettyPrinter;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

public abstract class Command
implements StorageCommand {
    private int keyHash;
    private long key;
    private Mode mode;

    protected final void setup(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public int hashCode() {
        return this.keyHash;
    }

    public abstract String toString();

    public long getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    public abstract boolean handle(CommandVisitor var1) throws IOException;

    protected String beforeAndAfterToString(AbstractBaseRecord before, AbstractBaseRecord after) {
        return String.format("\t-%s%n\t+%s", before, after);
    }

    void writeDynamicRecords(WritableChannel channel, Collection<DynamicRecord> records) throws IOException {
        this.writeDynamicRecords(channel, records, records.size());
    }

    void writeDynamicRecords(WritableChannel channel, Iterable<DynamicRecord> records, int size) throws IOException {
        channel.putInt(size);
        for (DynamicRecord record : records) {
            this.writeDynamicRecord(channel, record);
        }
    }

    void writeDynamicRecord(WritableChannel channel, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            if (record.isCreated()) {
                inUse = (byte)(inUse | 2);
            }
            if (record.isStartRecord()) {
                inUse = (byte)(inUse | 0x20);
            }
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            channel.put(data, data.length);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse);
        }
    }

    public static class RelationshipCountsCommand
    extends Command {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCountsCommand.class);
        private final int startLabelId;
        private final int typeId;
        private final int endLabelId;
        private final long delta;

        public RelationshipCountsCommand(int startLabelId, int typeId, int endLabelId, long delta) {
            this.setup(typeId, Mode.UPDATE);
            assert (delta != 0L) : "Tried to create a RelationshipCountsCommand for something that didn't change any count";
            this.startLabelId = startLabelId;
            this.typeId = typeId;
            this.endLabelId = endLabelId;
            this.delta = delta;
        }

        @Override
        public String toString() {
            return String.format("UpdateCounts[(%s)-%s->(%s) %s %d]", TokenIdPrettyPrinter.label((int)this.startLabelId), TokenIdPrettyPrinter.relationshipType((int)this.typeId), TokenIdPrettyPrinter.label((int)this.endLabelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCountsCommand(this);
        }

        public int startLabelId() {
            return this.startLabelId;
        }

        public int typeId() {
            return this.typeId;
        }

        public int endLabelId() {
            return this.endLabelId;
        }

        public long delta() {
            return this.delta;
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)16);
            channel.putInt(this.startLabelId()).putInt(this.typeId()).putInt(this.endLabelId()).putLong(this.delta());
        }
    }

    public static class NodeCountsCommand
    extends Command {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeCountsCommand.class);
        private final int labelId;
        private final long delta;

        public NodeCountsCommand(int labelId, long delta) {
            this.setup(labelId, Mode.UPDATE);
            assert (delta != 0L) : "Tried to create a NodeCountsCommand for something that didn't change any count";
            this.labelId = labelId;
            this.delta = delta;
        }

        @Override
        public String toString() {
            return String.format("UpdateCounts[(%s) %s %d]", TokenIdPrettyPrinter.label((int)this.labelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCountsCommand(this);
        }

        public int labelId() {
            return this.labelId;
        }

        public long delta() {
            return this.delta;
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)17);
            channel.putInt(this.labelId()).putLong(this.delta());
        }
    }

    public static class SchemaRuleCommand
    extends BaseCommand<SchemaRecord> {
        private final SchemaRule schemaRule;
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SchemaRuleCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * SchemaRecord.SHALLOW_SIZE;

        public SchemaRuleCommand(SchemaRecord recordBefore, SchemaRecord recordAfter, SchemaRule schemaRule) {
            super(recordBefore, recordAfter);
            this.schemaRule = schemaRule;
        }

        @Override
        public String toString() {
            String beforeAndAfterRecords = super.toString();
            if (this.schemaRule != null) {
                return beforeAndAfterRecords + " : " + this.schemaRule;
            }
            return beforeAndAfterRecords;
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitSchemaRuleCommand(this);
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)18);
            channel.putLong(((SchemaRecord)this.before).getId());
            boolean hasSchemaRule = this.schemaRule != null;
            channel.put(hasSchemaRule ? (byte)1 : 0);
            this.writeSchemaRecord(channel, (SchemaRecord)this.before);
            this.writeSchemaRecord(channel, (SchemaRecord)this.after);
            if (hasSchemaRule) {
                this.writeSchemaRule(channel);
            }
        }

        private void writeSchemaRecord(WritableChannel channel, SchemaRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((boolean)record.isCreated(), (byte)2), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8)});
            channel.put(flags);
            if (record.inUse()) {
                byte schemaFlags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.isConstraint(), (byte)1)});
                channel.put(schemaFlags);
                channel.putLong(record.getNextProp());
                if (record.hasSecondaryUnitId()) {
                    channel.putLong(record.getSecondaryUnitId());
                }
            }
        }

        private void writeSchemaRule(WritableChannel channel) throws IOException {
            Map<String, Value> ruleMap = SchemaStore.mapifySchemaRule(this.schemaRule);
            this.writeStringValueMap(channel, ruleMap);
        }

        void writeStringValueMap(WritableChannel channel, Map<String, Value> ruleMap) throws IOException {
            channel.putInt(ruleMap.size());
            for (Map.Entry<String, Value> entry : ruleMap.entrySet()) {
                this.writeMapKeyByteArray(channel, UTF8.encode((String)entry.getKey()));
                this.writeMapValue(channel, entry.getValue());
            }
        }

        private void writeMapKeyByteArray(WritableChannel channel, byte[] bytes) throws IOException {
            channel.putInt(bytes.length);
            channel.put(bytes, bytes.length);
        }

        private void writeMapValue(final WritableChannel channel, Value value) throws IOException {
            value.writeTo((ValueWriter)new ValueWriter<IOException>(){
                private boolean arrayContext;

                public void writeNull() throws IOException {
                    throw new IOException("Cannot write null entry value in schema record map representation.");
                }

                public void writeBoolean(boolean value) throws IOException {
                    if (value) {
                        channel.put(SchemaMapValueType.BOOL_LITERAL_TRUE.type());
                    } else {
                        channel.put(SchemaMapValueType.BOOL_LITERAL_FALSE.type());
                    }
                }

                public void writeInteger(byte value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.BYTE.type());
                    }
                    channel.put(value);
                }

                public void writeInteger(short value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.SHORT.type());
                    }
                    channel.putShort(value);
                }

                public void writeInteger(int value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.INT.type());
                    }
                    channel.putInt(value);
                }

                public void writeInteger(long value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.LONG.type());
                    }
                    channel.putLong(value);
                }

                public void writeFloatingPoint(float value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.FLOAT.type());
                    }
                    channel.putFloat(value);
                }

                public void writeFloatingPoint(double value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.DOUBLE.type());
                    }
                    channel.putDouble(value);
                }

                public void writeString(String value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.STRING.type());
                    }
                    byte[] bytes = UTF8.encode((String)value);
                    channel.putInt(bytes.length);
                    channel.put(bytes, bytes.length);
                }

                public void writeString(char value) throws IOException {
                    if (!this.arrayContext) {
                        channel.put(SchemaMapValueType.CHAR.type());
                    }
                    channel.putInt((int)value);
                }

                public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
                    this.arrayContext = true;
                    channel.put(SchemaMapValueType.ARRAY.type());
                    channel.putInt(size);
                    channel.put(SchemaMapValueType.map(arrayType).type());
                }

                public void endArray() {
                    this.arrayContext = false;
                }

                public void writeByteArray(byte[] value) throws IOException {
                    this.beginArray(value.length, ValueWriter.ArrayType.BYTE);
                    for (byte b : value) {
                        this.writeInteger(b);
                    }
                    this.endArray();
                }

                public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
                    throw new IOException("Point is not a supported schema map value type.");
                }

                public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
                    throw new IOException("Duration is not a supported schema map value type.");
                }

                public void writeDate(LocalDate localDate) throws IOException {
                    throw new IOException("Date is not a supported schema map value type.");
                }

                public void writeLocalTime(LocalTime localTime) throws IOException {
                    throw new IOException("LocalTime is not a supported schema map value type.");
                }

                public void writeTime(OffsetTime offsetTime) throws IOException {
                    throw new IOException("OffsetTime is not a supported schema map value type.");
                }

                public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
                    throw new IOException("LocalDateTime is not a supported schema map value type.");
                }

                public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
                    throw new IOException("DateTime is not a supported schema map value type.");
                }
            });
        }

        static enum SchemaMapValueType {
            BOOL_LITERAL_TRUE,
            BOOL_LITERAL_FALSE,
            BOOL_ARRAY_ELEMENT,
            BYTE,
            SHORT,
            INT,
            LONG,
            FLOAT,
            DOUBLE,
            STRING,
            CHAR,
            ARRAY;

            private static final SchemaMapValueType[] TYPE_ID_TO_ENUM;

            public static SchemaMapValueType map(byte type) {
                return TYPE_ID_TO_ENUM[type];
            }

            public static SchemaMapValueType map(ValueWriter.ArrayType arrayType) throws IOException {
                switch (arrayType) {
                    case BYTE: {
                        return BYTE;
                    }
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                    case FLOAT: {
                        return FLOAT;
                    }
                    case DOUBLE: {
                        return DOUBLE;
                    }
                    case BOOLEAN: {
                        return BOOL_ARRAY_ELEMENT;
                    }
                    case STRING: {
                        return STRING;
                    }
                    case CHAR: {
                        return CHAR;
                    }
                }
                throw new IOException("Unsupported schema record map value type: " + arrayType);
            }

            public byte type() {
                return (byte)this.ordinal();
            }

            static {
                TYPE_ID_TO_ENUM = SchemaMapValueType.values();
            }
        }
    }

    public static class LabelTokenCommand
    extends TokenCommand<LabelTokenRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LabelTokenCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * LabelTokenRecord.SHALLOW_SIZE;

        public LabelTokenCommand(LabelTokenRecord before, LabelTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitLabelTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)8);
            channel.putInt(((LabelTokenRecord)this.after).getIntId());
            this.writeLabelTokenRecord(channel, (LabelTokenRecord)this.before);
            this.writeLabelTokenRecord(channel, (LabelTokenRecord)this.after);
        }

        private void writeLabelTokenRecord(WritableChannel channel, LabelTokenRecord record) throws IOException {
            byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
            channel.put(headerByte).putInt(record.getNameId());
            this.writeDynamicRecords(channel, record.getNameRecords());
        }
    }

    public static class RelationshipTypeTokenCommand
    extends TokenCommand<RelationshipTypeTokenRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipTypeTokenCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * RelationshipTypeTokenRecord.SHALLOW_SIZE;

        public RelationshipTypeTokenCommand(RelationshipTypeTokenRecord before, RelationshipTypeTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipTypeTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)4);
            channel.putInt(((RelationshipTypeTokenRecord)this.after).getIntId());
            this.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)this.before);
            this.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)this.after);
        }

        private void writeRelationshipTypeTokenRecord(WritableChannel channel, RelationshipTypeTokenRecord record) throws IOException {
            byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
            channel.put(headerByte);
            channel.putInt(record.getNameId());
            if (record.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, record.getNameRecords());
            }
        }
    }

    public static class PropertyKeyTokenCommand
    extends TokenCommand<PropertyKeyTokenRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyKeyTokenCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * PropertyKeyTokenRecord.SHALLOW_SIZE;

        public PropertyKeyTokenCommand(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyKeyTokenCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)5);
            channel.putInt(((PropertyKeyTokenRecord)this.after).getIntId());
            this.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)this.before);
            this.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)this.after);
        }

        private void writePropertyKeyTokenRecord(WritableChannel channel, PropertyKeyTokenRecord record) throws IOException {
            byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
            channel.put(headerByte);
            channel.putInt(record.getPropertyCount()).putInt(record.getNameId());
            if (record.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, record.getNameRecords());
            }
        }
    }

    public static abstract class TokenCommand<RECORD extends TokenRecord>
    extends BaseCommand<RECORD>
    implements StorageCommand.TokenCommand {
        public TokenCommand(RECORD before, RECORD after) {
            super(before, after);
        }

        public int tokenId() {
            return Math.toIntExact(this.getKey());
        }

        public boolean isInternal() {
            return ((TokenRecord)this.getAfter()).isInternal();
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString(this.before, this.after);
        }
    }

    public static class PropertyCommand
    extends BaseCommand<PropertyRecord>
    implements PropertyRecordChange {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * PropertyRecord.INITIAL_SIZE;

        public PropertyCommand(PropertyRecord before, PropertyRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitPropertyCommand(this);
        }

        public long getEntityId() {
            return ((PropertyRecord)this.after).isNodeSet() ? ((PropertyRecord)this.after).getNodeId() : ((PropertyRecord)this.after).getRelId();
        }

        public long getNodeId() {
            return ((PropertyRecord)this.after).getNodeId();
        }

        public long getRelId() {
            return ((PropertyRecord)this.after).getRelId();
        }

        public long getSchemaRuleId() {
            return ((PropertyRecord)this.after).getSchemaRuleId();
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)2);
            channel.putLong(((PropertyRecord)this.after).getId());
            this.writePropertyRecord(channel, (PropertyRecord)this.before);
            this.writePropertyRecord(channel, (PropertyRecord)this.after);
        }

        private void writePropertyRecord(WritableChannel channel, PropertyRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((record.getRelId() != -1L ? 1 : 0) != 0, (byte)Record.REL_PROPERTY.byteValue()), Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16)});
            channel.put(flags);
            channel.putLong(record.getNextProp()).putLong(record.getPrevProp());
            long nodeId = record.getNodeId();
            long relId = record.getRelId();
            if (nodeId != -1L) {
                channel.putLong(nodeId);
            } else if (relId != -1L) {
                channel.putLong(relId);
            } else {
                channel.putLong(-1L);
            }
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
            channel.put((byte)record.numberOfProperties());
            for (PropertyBlock block : record) {
                assert (block.getSize() > 0) : record + " seems kinda broken";
                this.writePropertyBlock(channel, block);
            }
            this.writeDynamicRecords(channel, record.getDeletedRecords());
        }

        private void writePropertyBlock(WritableChannel channel, PropertyBlock block) throws IOException {
            long[] propBlockValues;
            byte blockSize = (byte)block.getSize();
            assert (blockSize > 0) : blockSize + " is not a valid block size value";
            channel.put(blockSize);
            for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
                channel.putLong(propBlockValue);
            }
            if (block.isLight()) {
                channel.putInt(0);
            } else {
                this.writeDynamicRecords(channel, block.getValueRecords());
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static class NeoStoreCommand
    extends BaseCommand<NeoStoreRecord> {
        NeoStoreCommand(NeoStoreRecord before, NeoStoreRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return false;
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)6);
            this.writeNeoStoreRecord(channel, (NeoStoreRecord)this.before);
            this.writeNeoStoreRecord(channel, (NeoStoreRecord)this.after);
        }

        private void writeNeoStoreRecord(WritableChannel channel, NeoStoreRecord record) throws IOException {
            channel.putLong(record.getNextProp());
        }
    }

    public static class RelationshipGroupCommand
    extends BaseCommand<RelationshipGroupRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipGroupCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * RelationshipGroupRecord.SHALLOW_SIZE;

        public RelationshipGroupCommand(RelationshipGroupRecord before, RelationshipGroupRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipGroupCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            int relType = Math.max(((RelationshipGroupRecord)this.before).getType(), ((RelationshipGroupRecord)this.after).getType());
            if (relType == Record.NULL_REFERENCE.intValue() || relType >>> 16 == 0) {
                channel.put((byte)9);
                channel.putLong(((RelationshipGroupRecord)this.after).getId());
                this.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)this.before);
                this.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)this.after);
            } else {
                channel.put((byte)21);
                channel.putLong(((RelationshipGroupRecord)this.after).getId());
                this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)this.before);
                this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)this.after);
            }
        }

        private void writeRelationshipGroupRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16)});
            channel.put(flags);
            channel.putShort((short)record.getType());
            channel.putLong(record.getNext());
            channel.putLong(record.getFirstOut());
            channel.putLong(record.getFirstIn());
            channel.putLong(record.getFirstLoop());
            channel.putLong(record.getOwningNode());
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        }

        private void writeRelationshipGroupExtendedRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16)});
            channel.put(flags);
            channel.putShort((short)record.getType());
            channel.put((byte)(record.getType() >>> 16));
            channel.putLong(record.getNext());
            channel.putLong(record.getFirstOut());
            channel.putLong(record.getFirstIn());
            channel.putLong(record.getFirstLoop());
            channel.putLong(record.getOwningNode());
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        }
    }

    public static class RelationshipCommand
    extends BaseCommand<RelationshipRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * RelationshipRecord.SHALLOW_SIZE;

        public RelationshipCommand(RelationshipRecord before, RelationshipRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitRelationshipCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)3);
            channel.putLong(((RelationshipRecord)this.after).getId());
            this.writeRelationshipRecord(channel, (RelationshipRecord)this.before);
            this.writeRelationshipRecord(channel, (RelationshipRecord)this.after);
        }

        private void writeRelationshipRecord(WritableChannel channel, RelationshipRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((boolean)record.isCreated(), (byte)2), Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16)});
            channel.put(flags);
            if (record.inUse()) {
                channel.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp()).put((byte)((record.isFirstInFirstChain() ? 1 : 0) | (record.isFirstInSecondChain() ? 2 : 0)));
                if (record.hasSecondaryUnitId()) {
                    channel.putLong(record.getSecondaryUnitId());
                }
            } else {
                channel.putInt(record.getType());
            }
        }
    }

    public static class NodeCommand
    extends BaseCommand<NodeRecord> {
        static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeCommand.class);
        static final long HEAP_SIZE = SHALLOW_SIZE + 2L * NodeRecord.SHALLOW_SIZE;

        public NodeCommand(NodeRecord before, NodeRecord after) {
            super(before, after);
        }

        @Override
        public boolean handle(CommandVisitor handler) throws IOException {
            return handler.visitNodeCommand(this);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)1);
            channel.putLong(((NodeRecord)this.after).getId());
            this.writeNodeRecord(channel, (NodeRecord)this.before);
            this.writeNodeRecord(channel, (NodeRecord)this.after);
        }

        private void writeNodeRecord(WritableChannel channel, NodeRecord record) throws IOException {
            byte flags = Bits.bitFlags((byte[])new byte[]{Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), Bits.bitFlag((boolean)record.isCreated(), (byte)2), Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (byte)4), Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (byte)8), Bits.bitFlag((boolean)record.isUseFixedReferences(), (byte)16)});
            channel.put(flags);
            if (record.inUse()) {
                channel.put(record.isDense() ? (byte)1 : 0);
                channel.putLong(record.getNextRel()).putLong(record.getNextProp());
                channel.putLong(record.getLabelField());
                if (record.hasSecondaryUnitId()) {
                    channel.putLong(record.getSecondaryUnitId());
                }
            }
            this.writeDynamicRecords(channel, record.getDynamicLabelRecords());
        }
    }

    public static abstract class BaseCommand<RECORD extends AbstractBaseRecord>
    extends Command {
        protected final RECORD before;
        protected final RECORD after;

        public BaseCommand(RECORD before, RECORD after) {
            this.setup(((AbstractBaseRecord)after).getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString((AbstractBaseRecord)this.before, (AbstractBaseRecord)this.after);
        }

        public RECORD getBefore() {
            return this.before;
        }

        public RECORD getAfter() {
            return this.after;
        }
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }
}

