/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordState;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageCommand;

public class CountsRecordState
extends CountsDelta
implements RecordState {
    @Override
    public void extractCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap((long)this.nodeCounts.size() * Command.NodeCountsCommand.SHALLOW_SIZE + (long)this.relationshipCounts.size() * Command.RelationshipCountsCommand.SHALLOW_SIZE);
        this.nodeCounts.forEachKeyValue((LongLongProcedure & Serializable)(labelId, count) -> {
            if (count != 0L) {
                target.add(new Command.NodeCountsCommand(StrictMath.toIntExact(labelId), count));
            }
        });
        this.relationshipCounts.forEachKeyValue((Procedure2 & Serializable)(k, mutableLong) -> {
            long count = mutableLong.longValue();
            if (count != 0L) {
                target.add(new Command.RelationshipCountsCommand(k.startLabelId, k.typeId, k.endLabelId, count));
            }
        });
    }
}

