/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;

class CountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final CountsAccessor.Updater countsUpdater;
    private boolean haveUpdates;
    private boolean countsUpdaterClosed;

    CountsStoreTransactionApplier(CountsAccessor.Updater countsUpdater) {
        this.countsUpdater = countsUpdater;
    }

    @Override
    public void close() {
        this.closeCountsUpdaterIfOpen();
    }

    private void closeCountsUpdaterIfOpen() {
        if (!this.countsUpdaterClosed) {
            this.countsUpdater.close();
            this.countsUpdaterClosed = true;
        }
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater.incrementNodeCount((long)command.labelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater.incrementRelationshipCount((long)command.startLabelId(), command.typeId(), (long)command.endLabelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        assert (!this.haveUpdates) : "Assumed that a schema transaction wouldn't also contain data commands affecting counts store, but was proven wrong with this transaction";
        this.closeCountsUpdaterIfOpen();
        return false;
    }
}

