/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class DirectRecordAccess<RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private final RecordStore<RECORD> store;
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final Map<Long, DirectRecordProxy> batch = new HashMap<Long, DirectRecordProxy>();
    private final MutableInt changeCounter = new MutableInt();

    public DirectRecordAccess(RecordStore<RECORD> store, RecordAccess.Loader<RECORD, ADDITIONAL> loader) {
        this.store = store;
        this.loader = loader;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        DirectRecordProxy loaded = this.batch.get(key);
        if (loaded != null) {
            return loaded;
        }
        return this.proxy(key, (AbstractBaseRecord)this.loader.load(key, additionalData, cursorTracer), additionalData, false, cursorTracer);
    }

    private RecordAccess.RecordProxy<RECORD, ADDITIONAL> putInBatch(long key, DirectRecordProxy proxy) {
        DirectRecordProxy previous = this.batch.put(key, proxy);
        assert (previous == null);
        return proxy;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        return this.proxy(key, (AbstractBaseRecord)this.loader.newUnused(key, additionalData), additionalData, true, cursorTracer);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return this.batch.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }

    @Override
    public Collection<DirectRecordProxy> changes() {
        return this.batch.values();
    }

    private DirectRecordProxy proxy(long key, RECORD record, ADDITIONAL additionalData, boolean created, PageCursorTracer cursorTracer) {
        return new DirectRecordProxy(this, key, record, additionalData, created, cursorTracer);
    }

    public void commit() {
        if (this.changeCounter.intValue() == 0) {
            return;
        }
        ArrayList<DirectRecordProxy> directRecordProxies = new ArrayList<DirectRecordProxy>(this.batch.values());
        directRecordProxies.sort((o1, o2) -> Long.compare(-o1.getKey(), o2.getKey()));
        for (DirectRecordProxy proxy : directRecordProxies) {
            proxy.store();
        }
        this.changeCounter.setValue(0);
        this.batch.clear();
    }

    private class DirectRecordProxy
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final long key;
        private final RECORD record;
        private final ADDITIONAL additionalData;
        private final PageCursorTracer cursorTracer;
        private boolean changed;
        private final boolean created;
        final /* synthetic */ DirectRecordAccess this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        DirectRecordProxy(long record, RECORD created, ADDITIONAL cursorTracer, boolean bl, PageCursorTracer pageCursorTracer) {
            void additionalData;
            void key;
            this.this$0 = (DirectRecordAccess)l;
            this.key = key;
            this.record = record;
            this.additionalData = additionalData;
            this.cursorTracer = cursorTracer;
            if (created != false) {
                this.prepareChange();
            }
            this.created = created;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            this.prepareChange();
            return this.record;
        }

        private void prepareChange() {
            if (!this.changed) {
                this.changed = true;
                this.this$0.putInBatch(this.key, this);
                this.this$0.changeCounter.increment();
            }
        }

        @Override
        public RECORD forChangingData() {
            this.this$0.loader.ensureHeavy(this.record, this.cursorTracer);
            this.prepareChange();
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.this$0.loader.ensureHeavy(this.record, this.cursorTracer);
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public RECORD getBefore() {
            return (AbstractBaseRecord)this.this$0.loader.load(this.key, this.additionalData, this.cursorTracer);
        }

        public String toString() {
            return this.record.toString();
        }

        public void store() {
            if (this.changed) {
                this.this$0.store.updateRecord(this.record, IdUpdateListener.IGNORE, this.cursorTracer);
            }
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }
    }
}

