/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.DirectRecordAccess;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class DirectRecordAccessSet
implements RecordAccessSet {
    private final DirectRecordAccess<NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<RelationshipGroupRecord, Integer> relationshipGroupRecords;
    private final DirectRecordAccess<PropertyKeyTokenRecord, Void> propertyKeyTokenRecords;
    private final DirectRecordAccess<RelationshipTypeTokenRecord, Void> relationshipTypeTokenRecords;
    private final DirectRecordAccess<LabelTokenRecord, Void> labelTokenRecords;
    private final DirectRecordAccess[] all;
    private final IdGeneratorFactory idGeneratorFactory;

    public DirectRecordAccessSet(NeoStores neoStores, IdGeneratorFactory idGeneratorFactory) {
        NodeStore nodeStore = neoStores.getNodeStore();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RelationshipGroupStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        RelationshipTypeTokenStore relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        LabelTokenStore labelTokenStore = neoStores.getLabelTokenStore();
        SchemaStore schemaStore = neoStores.getSchemaStore();
        Loaders loaders = new Loaders(nodeStore, propertyStore, relationshipStore, relationshipGroupStore, propertyKeyTokenStore, relationshipTypeTokenStore, labelTokenStore, schemaStore);
        this.nodeRecords = new DirectRecordAccess<NodeRecord, Void>(nodeStore, loaders.nodeLoader());
        this.propertyRecords = new DirectRecordAccess<PropertyRecord, PrimitiveRecord>(propertyStore, loaders.propertyLoader());
        this.relationshipRecords = new DirectRecordAccess<RelationshipRecord, Void>(relationshipStore, loaders.relationshipLoader());
        this.relationshipGroupRecords = new DirectRecordAccess<RelationshipGroupRecord, Integer>(relationshipGroupStore, loaders.relationshipGroupLoader());
        this.propertyKeyTokenRecords = new DirectRecordAccess<PropertyKeyTokenRecord, Void>(propertyKeyTokenStore, loaders.propertyKeyTokenLoader());
        this.relationshipTypeTokenRecords = new DirectRecordAccess<RelationshipTypeTokenRecord, Void>(relationshipTypeTokenStore, loaders.relationshipTypeTokenLoader());
        this.labelTokenRecords = new DirectRecordAccess<LabelTokenRecord, Void>(labelTokenStore, loaders.labelTokenLoader());
        this.all = new DirectRecordAccess[]{this.nodeRecords, this.propertyRecords, this.relationshipRecords, this.relationshipGroupRecords, this.propertyKeyTokenRecords, this.relationshipTypeTokenRecords, this.labelTokenRecords};
        this.idGeneratorFactory = idGeneratorFactory;
    }

    @Override
    public RecordAccess<NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException("Not needed. Implement if needed");
    }

    @Override
    public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenRecords;
    }

    @Override
    public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenRecords;
    }

    @Override
    public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenRecords;
    }

    public void commit() {
        for (DirectRecordAccess access : this.all) {
            access.commit();
        }
        this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
    }

    @Override
    public boolean hasChanges() {
        for (DirectRecordAccess access : this.all) {
            if (access.changeSize() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int changeSize() {
        int total = 0;
        for (DirectRecordAccess access : this.all) {
            total += access.changeSize();
        }
        return total;
    }
}

