/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.EnumMap;
import java.util.Map;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.ChangedIds;
import org.neo4j.internal.recordstorage.IdGeneratorUpdateWork;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.util.concurrent.WorkSync;

class EnqueuingIdUpdateListener
implements IdUpdateListener {
    private final EnumMap<IdType, ChangedIds> idUpdates;
    private final Map<IdType, WorkSync<IdGenerator, IdGeneratorUpdateWork>> idGeneratorWorkSyncs;
    private final PageCacheTracer pageCacheTracer;

    EnqueuingIdUpdateListener(Map<IdType, WorkSync<IdGenerator, IdGeneratorUpdateWork>> idGeneratorWorkSyncs, PageCacheTracer pageCacheTracer) {
        this.pageCacheTracer = pageCacheTracer;
        this.idUpdates = new EnumMap(IdType.class);
        this.idGeneratorWorkSyncs = idGeneratorWorkSyncs;
    }

    @Override
    public void markIdAsUsed(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
        this.idUpdates.computeIfAbsent(idType, k -> new ChangedIds()).addUsedId(id);
    }

    @Override
    public void markIdAsUnused(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
        this.idUpdates.computeIfAbsent(idType, k -> new ChangedIds()).addUnusedId(id);
    }

    @Override
    public void close() throws Exception {
        ChangedIds unit;
        for (Map.Entry<IdType, ChangedIds> idChanges : this.idUpdates.entrySet()) {
            unit = idChanges.getValue();
            unit.applyAsync(this.idGeneratorWorkSyncs.get(idChanges.getKey()), this.pageCacheTracer);
        }
        for (Map.Entry<IdType, ChangedIds> idChanges : this.idUpdates.entrySet()) {
            unit = idChanges.getValue();
            unit.awaitApply();
        }
    }
}

