/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.recordstorage.ChangedIds;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.util.concurrent.Work;

public class IdGeneratorUpdateWork
implements Work<IdGenerator, IdGeneratorUpdateWork> {
    public static final String ID_GENERATOR_BATCH_APPLIER_TAG = "idGeneratorBatchApplier";
    private final List<ChangedIds> changeList = new ArrayList<ChangedIds>();
    private final PageCacheTracer cacheTracer;

    IdGeneratorUpdateWork(ChangedIds changes, PageCacheTracer cacheTracer) {
        this.cacheTracer = cacheTracer;
        this.changeList.add(changes);
    }

    public IdGeneratorUpdateWork combine(IdGeneratorUpdateWork work) {
        this.changeList.addAll(work.changeList);
        return this;
    }

    public void apply(IdGenerator idGenerator) {
        try (PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(ID_GENERATOR_BATCH_APPLIER_TAG);
             IdGenerator.Marker marker = idGenerator.marker(cursorTracer);){
            for (ChangedIds changes : this.changeList) {
                changes.accept(marker);
            }
        }
    }
}

