/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.storageengine.api.IndexUpdateListener;

public class IndexActivator
implements AutoCloseable {
    private final IndexUpdateListener listener;
    private Set<IndexDescriptor> indexesToActivate;

    IndexActivator(IndexUpdateListener listener) {
        this.listener = listener;
    }

    @Override
    public void close() {
        if (this.indexesToActivate != null) {
            for (IndexDescriptor index : this.indexesToActivate) {
                try {
                    this.listener.activateIndex(index);
                }
                catch (KernelException e) {
                    throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                }
            }
        }
    }

    void activateIndex(IndexDescriptor index) {
        if (this.indexesToActivate == null) {
            this.indexesToActivate = new HashSet<IndexDescriptor>();
        }
        this.indexesToActivate.add(index);
    }

    void indexDropped(IndexDescriptor index) {
        if (this.indexesToActivate != null) {
            this.indexesToActivate.remove(index);
        }
    }
}

