/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.Subject;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.PropertyCommandsExtractor;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;

public class IndexTransactionApplierFactory
implements TransactionApplierFactory {
    private final IndexUpdateListener indexUpdateListener;

    public IndexTransactionApplierFactory(IndexUpdateListener indexUpdateListener) {
        this.indexUpdateListener = indexUpdateListener;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply commands, BatchContext batchContext) {
        return new SingleTransactionApplier(commands, batchContext);
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final long txId;
        private final Subject subject;
        private final PropertyCommandsExtractor indexUpdatesExtractor = new PropertyCommandsExtractor();
        private List<IndexDescriptor> createdIndexes;
        private final IndexActivator indexActivator;
        private final BatchContext batchContext;

        SingleTransactionApplier(CommandsToApply commands, BatchContext batchContext) {
            this.txId = commands.transactionId();
            this.subject = commands.subject();
            this.indexActivator = batchContext.getIndexActivator();
            this.batchContext = batchContext;
        }

        @Override
        public void close() throws IOException {
            if (this.indexUpdatesExtractor.containsAnyEntityOrPropertyUpdate()) {
                this.batchContext.indexUpdates().feed(this.indexUpdatesExtractor.getNodeCommands(), this.indexUpdatesExtractor.getRelationshipCommands());
                this.indexUpdatesExtractor.close();
            }
            if (this.createdIndexes != null) {
                IndexTransactionApplierFactory.this.indexUpdateListener.createIndexes(this.subject, this.createdIndexes.toArray(new IndexDescriptor[0]));
                this.createdIndexes = null;
            }
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) {
            NodeRecord before = (NodeRecord)command.getBefore();
            NodeRecord after = (NodeRecord)command.getAfter();
            NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
            NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
            if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
                long[] labelsBefore = labelFieldBefore.getIfLoaded();
                long[] labelsAfter = labelFieldAfter.getIfLoaded();
                if (labelsBefore != null && labelsAfter != null) {
                    this.batchContext.labelUpdates().add(EntityTokenUpdate.tokenChanges((long)command.getKey(), (long[])labelsBefore, (long[])labelsAfter, (long)this.txId));
                }
            }
            return this.indexUpdatesExtractor.visitNodeCommand(command);
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
            long[] lArray;
            long[] lArray2;
            RelationshipRecord before = (RelationshipRecord)command.getBefore();
            RelationshipRecord after = (RelationshipRecord)command.getAfter();
            int beforeType = before.getType();
            int afterType = after.getType();
            if (beforeType == -1 || !before.inUse()) {
                lArray2 = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
            } else {
                long[] lArray3 = new long[1];
                lArray2 = lArray3;
                lArray3[0] = beforeType;
            }
            long[] beforeArray = lArray2;
            if (afterType == -1 || !after.inUse()) {
                lArray = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
            } else {
                long[] lArray4 = new long[1];
                lArray = lArray4;
                lArray4[0] = afterType;
            }
            long[] afterArray = lArray;
            if (!Arrays.equals(beforeArray, afterArray)) {
                this.batchContext.relationshipTypeUpdates().add(EntityTokenUpdate.tokenChanges((long)command.getKey(), (long[])beforeArray, (long[])afterArray));
            }
            return this.indexUpdatesExtractor.visitRelationshipCommand(command);
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) {
            return this.indexUpdatesExtractor.visitPropertyCommand(command);
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            SchemaRule schemaRule = command.getSchemaRule();
            this.processSchemaCommand(command.getMode(), schemaRule);
            return false;
        }

        private void processSchemaCommand(Command.Mode commandMode, SchemaRule schemaRule) throws IOException {
            if (schemaRule instanceof IndexDescriptor) {
                IndexDescriptor indexRule = (IndexDescriptor)schemaRule;
                this.batchContext.applyPendingLabelAndIndexUpdates();
                switch (commandMode) {
                    case UPDATE: {
                        if (!indexRule.isUnique()) break;
                        this.indexActivator.activateIndex(indexRule);
                        break;
                    }
                    case CREATE: {
                        this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                        this.createdIndexes.add(indexRule);
                        break;
                    }
                    case DELETE: {
                        IndexTransactionApplierFactory.this.indexUpdateListener.dropIndex(indexRule);
                        this.indexActivator.indexDropped(indexRule);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(commandMode.name());
                    }
                }
            }
        }
    }
}

