/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.collection.NestingIterator;
import org.neo4j.internal.recordstorage.IndexUpdates;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.util.concurrent.Work;

public class IndexUpdatesWork
implements Work<IndexUpdateListener, IndexUpdatesWork> {
    private final List<IndexUpdates> updates = new ArrayList<IndexUpdates>();
    private final PageCursorTracer cursorTracer;

    public IndexUpdatesWork(IndexUpdates updates, PageCursorTracer cursorTracer) {
        this.cursorTracer = cursorTracer;
        this.updates.add(updates);
    }

    public IndexUpdatesWork combine(IndexUpdatesWork work) {
        this.updates.addAll(work.updates);
        return this;
    }

    public void apply(IndexUpdateListener material) {
        try {
            material.applyUpdates(this.combinedUpdates(), this.cursorTracer);
        }
        catch (IOException | KernelException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private Iterable<IndexEntryUpdate<IndexDescriptor>> combinedUpdates() {
        return () -> new NestingIterator<IndexEntryUpdate<IndexDescriptor>, IndexUpdates>(this.updates.iterator()){

            protected Iterator<IndexEntryUpdate<IndexDescriptor>> createNestedIterator(IndexUpdates item) {
                return item.iterator();
            }
        };
    }
}

