/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.util.Preconditions;

class IntegrityValidator {
    private final NeoStores neoStores;
    private IndexUpdateListener indexValidator;

    IntegrityValidator(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    void setIndexValidator(IndexUpdateListener validator) {
        Preconditions.checkState((this.indexValidator == null ? 1 : 0) != 0, (String)("Only supports a single validator. Tried to add " + validator + ", but " + this.indexValidator + " has already been added"));
        this.indexValidator = validator;
    }

    void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw new ConstraintViolationTransactionFailureException("Cannot delete node<" + record.getId() + ">, because it still has relationships. To delete this node, you must first delete its relationships.");
        }
    }

    void validateTransactionStartKnowledge(long lastCommittedTxWhenTransactionStarted) throws TransactionFailureException {
        long latestConstraintIntroducingTx = this.neoStores.getMetaDataStore().getLatestConstraintIntroducingTx();
        if (lastCommittedTxWhenTransactionStarted < latestConstraintIntroducingTx) {
            throw new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Database constraints have changed (txId=%d) after this transaction (txId=%d) started, which is not yet supported. Please retry your transaction to ensure all constraints are executed.", new Object[]{latestConstraintIntroducingTx, lastCommittedTxWhenTransactionStarted});
        }
    }

    void validateSchemaRule(SchemaRule schemaRule) throws TransactionFailureException {
        ConstraintDescriptor constraint;
        Preconditions.checkState((this.indexValidator != null ? 1 : 0) != 0, (String)"No index validator installed");
        if (schemaRule instanceof ConstraintDescriptor && (constraint = (ConstraintDescriptor)schemaRule).isIndexBackedConstraint()) {
            long ownedIndex = constraint.asIndexBackedConstraint().ownedIndexId();
            try {
                this.indexValidator.validateIndex(ownedIndex);
            }
            catch (KernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionValidationFailed, (Throwable)e, "Index validation of " + schemaRule + " failed, specifically for its owned index " + ownedIndex, new Object[]{e});
            }
        }
    }
}

