/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class Loaders {
    private final RecordAccess.Loader<NodeRecord, Void> nodeLoader;
    private final RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader;
    private final RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader;
    private final RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader;
    private final RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader;
    private final RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader;
    private final RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader;
    private final RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader;

    public Loaders(NeoStores neoStores) {
        this(neoStores.getNodeStore(), neoStores.getPropertyStore(), neoStores.getRelationshipStore(), neoStores.getRelationshipGroupStore(), neoStores.getPropertyKeyTokenStore(), neoStores.getRelationshipTypeTokenStore(), neoStores.getLabelTokenStore(), neoStores.getSchemaStore());
    }

    public Loaders(RecordStore<NodeRecord> nodeStore, PropertyStore propertyStore, RecordStore<RelationshipRecord> relationshipStore, RecordStore<RelationshipGroupRecord> relationshipGroupStore, RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore, RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore, RecordStore<LabelTokenRecord> labelTokenStore, SchemaStore schemaStore) {
        this.nodeLoader = Loaders.nodeLoader(nodeStore);
        this.propertyLoader = Loaders.propertyLoader(propertyStore);
        this.relationshipLoader = Loaders.relationshipLoader(relationshipStore);
        this.relationshipGroupLoader = Loaders.relationshipGroupLoader(relationshipGroupStore);
        this.schemaRuleLoader = Loaders.schemaRuleLoader(schemaStore);
        this.propertyKeyTokenLoader = Loaders.propertyKeyTokenLoader(propertyKeyTokenStore);
        this.labelTokenLoader = Loaders.labelTokenLoader(labelTokenStore);
        this.relationshipTypeTokenLoader = Loaders.relationshipTypeTokenLoader(relationshipTypeTokenStore);
    }

    public RecordAccess.Loader<NodeRecord, Void> nodeLoader() {
        return this.nodeLoader;
    }

    public RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader() {
        return this.propertyLoader;
    }

    public RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader() {
        return this.relationshipLoader;
    }

    public RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader() {
        return this.relationshipGroupLoader;
    }

    public RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader() {
        return this.schemaRuleLoader;
    }

    public RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader() {
        return this.propertyKeyTokenLoader;
    }

    public RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader() {
        return this.labelTokenLoader;
    }

    public RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader() {
        return this.relationshipTypeTokenLoader;
    }

    public static RecordAccess.Loader<NodeRecord, Void> nodeLoader(final RecordStore<NodeRecord> store) {
        return new RecordAccess.Loader<NodeRecord, Void>(){

            @Override
            public NodeRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new NodeRecord(key));
            }

            @Override
            public NodeRecord load(long key, Void additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (NodeRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(NodeRecord record, PageCursorTracer cursorTracer) {
                store.ensureHeavy(record, cursorTracer);
            }

            @Override
            public NodeRecord copy(NodeRecord nodeRecord) {
                return new NodeRecord(nodeRecord);
            }
        };
    }

    public static RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader(final PropertyStore store) {
        return new RecordAccess.Loader<PropertyRecord, PrimitiveRecord>(){

            @Override
            public PropertyRecord newUnused(long key, PrimitiveRecord additionalData) {
                PropertyRecord record = new PropertyRecord(key);
                this.setOwner(record, additionalData);
                return Loaders.andMarkAsCreated(record);
            }

            private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
                if (owner != null) {
                    owner.setIdTo(record);
                }
            }

            @Override
            public PropertyRecord load(long key, PrimitiveRecord additionalData, PageCursorTracer cursorTracer) {
                PropertyRecord record = store.getRecord(key, store.newRecord(), RecordLoad.NORMAL, cursorTracer);
                this.setOwner(record, additionalData);
                return record;
            }

            @Override
            public void ensureHeavy(PropertyRecord record, PageCursorTracer cursorTracer) {
                for (PropertyBlock block : record) {
                    store.ensureHeavy(block, cursorTracer);
                }
            }

            @Override
            public PropertyRecord copy(PropertyRecord propertyRecord) {
                return new PropertyRecord(propertyRecord);
            }
        };
    }

    public static RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader(final RecordStore<RelationshipRecord> store) {
        return new RecordAccess.Loader<RelationshipRecord, Void>(){

            @Override
            public RelationshipRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipRecord(key));
            }

            @Override
            public RelationshipRecord load(long key, Void additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (RelationshipRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(RelationshipRecord record, PageCursorTracer cursorTracer) {
            }

            @Override
            public RelationshipRecord copy(RelationshipRecord relationshipRecord) {
                return new RelationshipRecord(relationshipRecord);
            }
        };
    }

    public static RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader(final RecordStore<RelationshipGroupRecord> store) {
        return new RecordAccess.Loader<RelationshipGroupRecord, Integer>(){

            @Override
            public RelationshipGroupRecord newUnused(long key, Integer type) {
                RelationshipGroupRecord record = new RelationshipGroupRecord(key);
                record.setType(type);
                return Loaders.andMarkAsCreated(record);
            }

            @Override
            public RelationshipGroupRecord load(long key, Integer type, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (RelationshipGroupRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(RelationshipGroupRecord record, PageCursorTracer cursorTracer) {
            }

            @Override
            public RelationshipGroupRecord copy(RelationshipGroupRecord record) {
                return new RelationshipGroupRecord(record);
            }
        };
    }

    private static RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader(final SchemaStore store) {
        return new RecordAccess.Loader<SchemaRecord, SchemaRule>(){

            @Override
            public SchemaRecord newUnused(long key, SchemaRule additionalData) {
                return Loaders.andMarkAsCreated(new SchemaRecord(key));
            }

            @Override
            public SchemaRecord load(long key, SchemaRule additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (SchemaRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(SchemaRecord record, PageCursorTracer cursorTracer) {
            }

            @Override
            public SchemaRecord copy(SchemaRecord record) {
                return new SchemaRecord(record);
            }
        };
    }

    public static RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader(final RecordStore<PropertyKeyTokenRecord> store) {
        return new RecordAccess.Loader<PropertyKeyTokenRecord, Void>(){

            @Override
            public PropertyKeyTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new PropertyKeyTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public PropertyKeyTokenRecord load(long key, Void additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (PropertyKeyTokenRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(PropertyKeyTokenRecord record, PageCursorTracer cursorTracer) {
                store.ensureHeavy(record, cursorTracer);
            }

            @Override
            public PropertyKeyTokenRecord copy(PropertyKeyTokenRecord record) {
                return new PropertyKeyTokenRecord(record);
            }
        };
    }

    public static RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader(final RecordStore<LabelTokenRecord> store) {
        return new RecordAccess.Loader<LabelTokenRecord, Void>(){

            @Override
            public LabelTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new LabelTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public LabelTokenRecord load(long key, Void additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (LabelTokenRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(LabelTokenRecord record, PageCursorTracer cursorTracer) {
                store.ensureHeavy(record, cursorTracer);
            }

            @Override
            public LabelTokenRecord copy(LabelTokenRecord record) {
                return new LabelTokenRecord(record);
            }
        };
    }

    public static RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader(final RecordStore<RelationshipTypeTokenRecord> store) {
        return new RecordAccess.Loader<RelationshipTypeTokenRecord, Void>(){

            @Override
            public RelationshipTypeTokenRecord newUnused(long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipTypeTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public RelationshipTypeTokenRecord load(long key, Void additionalData, PageCursorTracer cursorTracer) {
                return store.getRecord(key, (RelationshipTypeTokenRecord)store.newRecord(), RecordLoad.NORMAL, cursorTracer);
            }

            @Override
            public void ensureHeavy(RelationshipTypeTokenRecord record, PageCursorTracer cursorTracer) {
                store.ensureHeavy(record, cursorTracer);
            }

            @Override
            public RelationshipTypeTokenRecord copy(RelationshipTypeTokenRecord record) {
                return new RelationshipTypeTokenRecord(record);
            }
        };
    }

    protected static <RECORD extends AbstractBaseRecord> RECORD andMarkAsCreated(RECORD record) {
        record.setCreated();
        return record;
    }
}

