/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.storageengine.api.CommandVersion;

public class NeoStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final CommandVersion version;
    private final LockGroup lockGroup;
    private final long transactionId;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final IdUpdateListener idUpdateListener;
    private final PageCursorTracer cursorTracer;

    public NeoStoreTransactionApplier(CommandVersion version, NeoStores neoStores, CacheAccessBackDoor cacheAccess, LockService lockService, long transactionId, BatchContext batchContext, PageCursorTracer cursorTracer) {
        this.version = version;
        this.lockGroup = batchContext.getLockGroup();
        this.transactionId = transactionId;
        this.lockService = lockService;
        this.neoStores = neoStores;
        this.cacheAccess = cacheAccess;
        this.idUpdateListener = batchContext.getIdUpdateListener();
        this.cursorTracer = cursorTracer;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockType.EXCLUSIVE));
        this.updateStore(this.neoStores.getNodeStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getKey(), LockType.EXCLUSIVE));
        this.updateStore(this.neoStores.getRelationshipStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (command.getNodeId() != -1L) {
            this.lockGroup.add(this.lockService.acquireNodeLock(command.getNodeId(), LockType.EXCLUSIVE));
        } else if (command.getRelId() != -1L) {
            this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getRelId(), LockType.EXCLUSIVE));
        }
        this.updateStore(this.neoStores.getPropertyStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.updateStore(this.neoStores.getRelationshipGroupStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        this.updateStore(this.neoStores.getRelationshipTypeTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        this.updateStore(this.neoStores.getLabelTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        this.updateStore(this.neoStores.getPropertyKeyTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        this.updateStore(this.neoStores.getSchemaStore(), command);
        SchemaRule schemaRule = command.getSchemaRule();
        boolean isConstraint = ((SchemaRecord)command.getAfter()).isConstraint();
        this.onSchemaRuleChange(command.getMode(), command.getKey(), schemaRule, isConstraint);
        return false;
    }

    private void onSchemaRuleChange(Command.Mode commandMode, long schemaRuleId, SchemaRule schemaRule, boolean isConstraint) {
        if (isConstraint) {
            switch (commandMode) {
                case UPDATE: 
                case CREATE: {
                    this.neoStores.getMetaDataStore().setLatestConstraintIntroducingTx(this.transactionId, this.cursorTracer);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(commandMode.name());
                }
            }
        }
        if (commandMode == Command.Mode.DELETE) {
            this.cacheAccess.removeSchemaRuleFromCache(schemaRuleId);
        } else {
            this.cacheAccess.addSchemaRule(schemaRule);
        }
    }

    private <RECORD extends AbstractBaseRecord> void updateStore(CommonAbstractStore<RECORD, ?> store, Command.BaseCommand<RECORD> command) {
        store.updateRecord(this.selectRecordByCommandVersion(command), this.idUpdateListener, this.cursorTracer);
    }

    private <RECORD extends AbstractBaseRecord> RECORD selectRecordByCommandVersion(Command.BaseCommand<RECORD> command) {
        switch (this.version) {
            case BEFORE: {
                return command.getBefore();
            }
            case AFTER: {
                return command.getAfter();
            }
        }
        throw new IllegalArgumentException("Unexpected command version " + this.version);
    }
}

