/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.CommandVersion;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class NeoStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final CommandVersion version;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;

    NeoStoreTransactionApplierFactory(TransactionApplicationMode mode, NeoStores store, CacheAccessBackDoor cacheAccess, LockService lockService) {
        this.version = mode.version();
        this.neoStores = store;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, BatchContext batchContext) {
        return new NeoStoreTransactionApplier(this.version, this.neoStores, this.cacheAccess, this.lockService, transaction.transactionId(), batchContext, transaction.cursorTracer());
    }
}

