/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.common.EntityType;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.EntityCommandGrouper;
import org.neo4j.internal.recordstorage.IndexUpdates;
import org.neo4j.internal.recordstorage.PropertyPhysicalToLogicalConverter;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final SchemaCache schemaCache;
    private final PropertyPhysicalToLogicalConverter converter;
    private final StorageReader reader;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;
    private final Collection<IndexEntryUpdate<IndexDescriptor>> updates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
    private StorageNodeCursor nodeCursor;
    private StorageRelationshipScanCursor relationshipCursor;

    public OnlineIndexUpdates(NodeStore nodeStore, SchemaCache schemaCache, PropertyPhysicalToLogicalConverter converter, StorageReader reader, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.nodeStore = nodeStore;
        this.schemaCache = schemaCache;
        this.converter = converter;
        this.reader = reader;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public Iterator<IndexEntryUpdate<IndexDescriptor>> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void feed(EntityCommandGrouper.Cursor nodeCommands, EntityCommandGrouper.Cursor relationshipCommands) {
        while (nodeCommands.nextEntity()) {
            this.gatherUpdatesFor(nodeCommands.currentEntityId(), (Command.NodeCommand)nodeCommands.currentEntityCommand(), nodeCommands);
        }
        while (relationshipCommands.nextEntity()) {
            this.gatherUpdatesFor(relationshipCommands.currentEntityId(), (Command.RelationshipCommand)relationshipCommands.currentEntityCommand(), relationshipCommands);
        }
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFor(long nodeId, Command.NodeCommand nodeCommand, EntityCommandGrouper.Cursor propertyCommands) {
        EntityUpdates.Builder nodePropertyUpdate = this.gatherUpdatesFromCommandsForNode(nodeId, nodeCommand, propertyCommands);
        this.eagerlyGatherUpdates(nodePropertyUpdate, EntityType.NODE);
    }

    private void gatherUpdatesFor(long relationshipId, Command.RelationshipCommand relationshipCommand, EntityCommandGrouper.Cursor propertyCommands) {
        EntityUpdates.Builder relationshipPropertyUpdate = this.gatherUpdatesFromCommandsForRelationship(relationshipId, relationshipCommand, propertyCommands);
        this.eagerlyGatherUpdates(relationshipPropertyUpdate, EntityType.RELATIONSHIP);
    }

    private void eagerlyGatherUpdates(EntityUpdates.Builder entityUpdatesBuilder, EntityType entityType) {
        EntityUpdates entityUpdates = entityUpdatesBuilder.build();
        Set<IndexDescriptor> relatedIndexes = this.schemaCache.getIndexesRelatedTo(entityUpdates.entityTokensChanged(), entityUpdates.entityTokensUnchanged(), entityUpdates.propertiesChanged(), entityUpdates.isPropertyListComplete(), entityType);
        entityUpdates.forIndexKeys(relatedIndexes, this.reader, entityType, this.cursorTracer, this.memoryTracker).forEach(this.updates::add);
    }

    private EntityUpdates.Builder gatherUpdatesFromCommandsForNode(long nodeId, Command.NodeCommand nodeChanges, EntityCommandGrouper.Cursor propertyCommandsForNode) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getBefore()).get(this.nodeStore, this.cursorTracer);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getAfter()).get(this.nodeStore, this.cursorTracer);
        } else {
            StorageNodeCursor nodeCursor = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = nodeCursor.labels();
        }
        boolean complete = OnlineIndexUpdates.providesCompleteListOfProperties(nodeChanges);
        EntityUpdates.Builder nodePropertyUpdates = EntityUpdates.forEntity((long)nodeId, (boolean)complete).withTokens(nodeLabelsBefore).withTokensAfter(nodeLabelsAfter);
        this.converter.convertPropertyRecord(propertyCommandsForNode, nodePropertyUpdates);
        return nodePropertyUpdates;
    }

    private static boolean providesCompleteListOfProperties(Command entityCommand) {
        return entityCommand != null && (entityCommand.getMode() == Command.Mode.CREATE || entityCommand.getMode() == Command.Mode.DELETE);
    }

    private EntityUpdates.Builder gatherUpdatesFromCommandsForRelationship(long relationshipId, Command.RelationshipCommand relationshipCommand, EntityCommandGrouper.Cursor propertyCommands) {
        long reltypeAfter;
        long reltypeBefore;
        if (relationshipCommand != null) {
            reltypeBefore = ((RelationshipRecord)relationshipCommand.getBefore()).getType();
            reltypeAfter = ((RelationshipRecord)relationshipCommand.getAfter()).getType();
        } else {
            reltypeBefore = reltypeAfter = (long)this.loadRelationship(relationshipId).type();
        }
        boolean complete = OnlineIndexUpdates.providesCompleteListOfProperties(relationshipCommand);
        EntityUpdates.Builder relationshipPropertyUpdates = EntityUpdates.forEntity((long)relationshipId, (boolean)complete).withTokens(new long[]{reltypeBefore}).withTokensAfter(new long[]{reltypeAfter});
        this.converter.convertPropertyRecord(propertyCommands, relationshipPropertyUpdates);
        return relationshipPropertyUpdates;
    }

    private StorageNodeCursor loadNode(long nodeId) {
        if (this.nodeCursor == null) {
            this.nodeCursor = this.reader.allocateNodeCursor(this.cursorTracer);
        }
        this.nodeCursor.single(nodeId);
        if (!this.nodeCursor.next()) {
            throw new IllegalStateException("Node[" + nodeId + "] doesn't exist");
        }
        return this.nodeCursor;
    }

    private StorageRelationshipScanCursor loadRelationship(long relationshipId) {
        if (this.relationshipCursor == null) {
            this.relationshipCursor = this.reader.allocateRelationshipScanCursor(this.cursorTracer);
        }
        this.relationshipCursor.single(relationshipId);
        if (!this.relationshipCursor.next()) {
            throw new IllegalStateException("Relationship[" + relationshipId + "] doesn't exist");
        }
        return this.relationshipCursor;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.relationshipCursor, this.reader});
    }

    public String toString() {
        return "OnlineIndexUpdates[" + this.updates + "]";
    }
}

