/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.BaseCommandReader;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandReading;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.string.UTF8;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PhysicalLogCommandReaderV4_0
extends BaseCommandReader {
    public static final CommandReader INSTANCE = new PhysicalLogCommandReaderV4_0();
    static final byte FORMAT_ID = 1;

    @Override
    protected Command read(byte commandType, ReadableChannel channel) throws IOException {
        switch (commandType) {
            case 1: {
                return this.visitNodeCommand(channel);
            }
            case 2: {
                return this.visitPropertyCommand(channel);
            }
            case 5: {
                return this.visitPropertyKeyTokenCommand(channel);
            }
            case 3: {
                return this.visitRelationshipCommand(channel);
            }
            case 4: {
                return this.visitRelationshipTypeTokenCommand(channel);
            }
            case 8: {
                return this.visitLabelTokenCommand(channel);
            }
            case 9: {
                return this.visitRelationshipGroupCommand(channel);
            }
            case 21: {
                return this.visitRelationshipGroupExtendedCommand(channel);
            }
            case 16: {
                return this.visitRelationshipCountsCommand(channel);
            }
            case 17: {
                return this.visitNodeCountsCommand(channel);
            }
            case 18: {
                return this.visitSchemaRuleCommand(channel);
            }
        }
        throw this.unknownCommandType(commandType, channel);
    }

    private Command visitNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = this.readNodeRecord(id, channel);
        if (before == null) {
            return null;
        }
        NodeRecord after = this.readNodeRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.NodeCommand(before, after);
    }

    private Command visitRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = this.readRelationshipRecord(id, channel);
        if (before == null) {
            return null;
        }
        RelationshipRecord after = this.readRelationshipRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipCommand(before, after);
    }

    private Command visitPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = this.readPropertyRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyRecord after = this.readPropertyRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyCommand(before, after);
    }

    private Command visitRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = this.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = this.readRelationshipGroupRecord(id, channel);
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand(before, after);
    }

    private RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((byte)flags, (byte)4);
        boolean hasSecondaryUnit = Bits.bitFlag((byte)flags, (byte)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((byte)flags, (byte)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    private Command visitRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = this.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = this.readRelationshipGroupExtendedRecord(id, channel);
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand(before, after);
    }

    private RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((byte)flags, (byte)4);
        boolean hasSecondaryUnit = Bits.bitFlag((byte)flags, (byte)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((byte)flags, (byte)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    private Command visitRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        RelationshipTypeTokenRecord before = this.readRelationshipTypeTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        RelationshipTypeTokenRecord after = this.readRelationshipTypeTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipTypeTokenCommand(before, after);
    }

    private RelationshipTypeTokenRecord readRelationshipTypeTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return record;
    }

    private Command visitLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        LabelTokenRecord before = this.readLabelTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        LabelTokenRecord after = this.readLabelTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.LabelTokenCommand(before, after);
    }

    private LabelTokenRecord readLabelTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return record;
    }

    private Command visitPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        PropertyKeyTokenRecord before = this.readPropertyKeyTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyKeyTokenRecord after = this.readPropertyKeyTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyKeyTokenCommand(before, after);
    }

    private PropertyKeyTokenRecord readPropertyKeyTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        if (this.readDynamicRecords(channel, record, CommandReading.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return record;
    }

    private Command visitSchemaRuleCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        byte schemaRulePresence = channel.get();
        boolean hasSchemaRule = schemaRulePresence == 1;
        SchemaRecord before = this.readSchemaRecord(id, channel);
        SchemaRecord after = this.readSchemaRecord(id, channel);
        PhysicalLogCommandReaderV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        SchemaRule schemaRule = null;
        if (hasSchemaRule) {
            schemaRule = this.readSchemaRule(id, channel);
        }
        return new Command.SchemaRuleCommand(before, after, schemaRule);
    }

    private SchemaRecord readSchemaRecord(long id, ReadableChannel channel) throws IOException {
        SchemaRecord schemaRecord = new SchemaRecord(id);
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        if (inUse) {
            schemaRecord.setInUse(inUse);
            if (Bits.bitFlag((byte)flags, (byte)2)) {
                schemaRecord.setCreated();
            }
            schemaRecord.setUseFixedReferences(Bits.bitFlag((byte)flags, (byte)16));
            byte schemaFlags = channel.get();
            schemaRecord.setConstraint(Bits.bitFlag((byte)schemaFlags, (byte)1));
            schemaRecord.setNextProp(channel.getLong());
            if (Bits.bitFlag((byte)flags, (byte)8)) {
                schemaRecord.setSecondaryUnitIdOnLoad(channel.getLong());
            }
        } else {
            schemaRecord.clear();
        }
        return schemaRecord;
    }

    private SchemaRule readSchemaRule(long id, ReadableChannel channel) throws IOException {
        Map<String, Value> ruleMap = this.readStringValueMap(channel);
        try {
            return SchemaStore.unmapifySchemaRule(id, ruleMap);
        }
        catch (MalformedSchemaRuleException e) {
            throw new IOException("Failed to create a schema rule from string-value map: " + ruleMap, e);
        }
    }

    Map<String, Value> readStringValueMap(ReadableChannel channel) throws IOException {
        HashMap<String, Value> map = new HashMap<String, Value>();
        int size = channel.getInt();
        for (int i = 0; i < size; ++i) {
            byte[] keyBytes = this.readMapKeyByteArray(channel);
            String key = UTF8.decode((byte[])keyBytes);
            Value value = this.readMapValue(channel);
            map.put(key, value);
        }
        return map;
    }

    private byte[] readMapKeyByteArray(ReadableChannel channel) throws IOException {
        int size = channel.getInt();
        byte[] bytes = new byte[size];
        channel.get(bytes, size);
        return bytes;
    }

    private Value readMapValue(ReadableChannel channel) throws IOException {
        Command.SchemaRuleCommand.SchemaMapValueType type = Command.SchemaRuleCommand.SchemaMapValueType.map(channel.get());
        switch (type) {
            case BOOL_LITERAL_TRUE: {
                return Values.booleanValue((boolean)true);
            }
            case BOOL_LITERAL_FALSE: {
                return Values.booleanValue((boolean)false);
            }
            case BOOL_ARRAY_ELEMENT: {
                throw new IOException("Cannot read schema rule map value of type boolean array element as a top-level type.");
            }
            case BYTE: {
                return Values.byteValue((byte)channel.get());
            }
            case SHORT: {
                return Values.shortValue((short)channel.getShort());
            }
            case INT: {
                return Values.intValue((int)channel.getInt());
            }
            case LONG: {
                return Values.longValue((long)channel.getLong());
            }
            case FLOAT: {
                return Values.floatValue((float)channel.getFloat());
            }
            case DOUBLE: {
                return Values.doubleValue((double)channel.getDouble());
            }
            case STRING: {
                int size = channel.getInt();
                byte[] bytes = new byte[size];
                channel.get(bytes, size);
                return Values.utf8Value((byte[])bytes);
            }
            case CHAR: {
                return Values.charValue((char)((char)channel.getInt()));
            }
            case ARRAY: {
                int arraySize = channel.getInt();
                Command.SchemaRuleCommand.SchemaMapValueType elementType = Command.SchemaRuleCommand.SchemaMapValueType.map(channel.get());
                switch (elementType) {
                    case BOOL_LITERAL_TRUE: {
                        throw new IOException("BOOL_LITERAL_TRUE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_LITERAL_FALSE: {
                        throw new IOException("BOOL_LITERAL_FALSE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_ARRAY_ELEMENT: {
                        boolean[] array = new boolean[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get() == Command.SchemaRuleCommand.SchemaMapValueType.BOOL_LITERAL_TRUE.type();
                        }
                        return Values.booleanArray((boolean[])array);
                    }
                    case BYTE: {
                        byte[] array = new byte[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get();
                        }
                        return Values.byteArray((byte[])array);
                    }
                    case SHORT: {
                        short[] array = new short[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getShort();
                        }
                        return Values.shortArray((short[])array);
                    }
                    case INT: {
                        int[] array = new int[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getInt();
                        }
                        return Values.intArray((int[])array);
                    }
                    case LONG: {
                        long[] array = new long[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getLong();
                        }
                        return Values.longArray((long[])array);
                    }
                    case FLOAT: {
                        float[] array = new float[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getFloat();
                        }
                        return Values.floatArray((float[])array);
                    }
                    case DOUBLE: {
                        double[] array = new double[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getDouble();
                        }
                        return Values.doubleArray((double[])array);
                    }
                    case STRING: {
                        String[] array = new String[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            int size = channel.getInt();
                            byte[] bytes = new byte[size];
                            channel.get(bytes, size);
                            array[i] = UTF8.decode((byte[])bytes);
                        }
                        return Values.stringArray((String[])array);
                    }
                    case CHAR: {
                        char[] array = new char[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = (char)channel.getInt();
                        }
                        return Values.charArray((char[])array);
                    }
                    case ARRAY: {
                        throw new IOException("Nested arrays are not support for schema rule map values.");
                    }
                }
                throw new IOException("Unknown array element type: " + elementType);
            }
        }
        throw new IOException("Unknown schema map value type: " + type);
    }

    private NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        NodeRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = Bits.bitFlag((byte)flags, (byte)2);
        boolean requiresSecondaryUnit = Bits.bitFlag((byte)flags, (byte)4);
        boolean hasSecondaryUnit = Bits.bitFlag((byte)flags, (byte)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((byte)flags, (byte)16);
        ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
        long labelField = Record.NO_LABELS_FIELD.intValue();
        if (inUse) {
            boolean dense = channel.get() == 1;
            long nextRel = channel.getLong();
            long nextProp = channel.getLong();
            record = new NodeRecord(id).initialize(false, nextProp, dense, nextRel, 0L);
            labelField = channel.getLong();
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new NodeRecord(id);
        }
        this.readDynamicRecords(channel, dynamicLabelRecords, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        record.setLabelField(labelField, dynamicLabelRecords);
        record.setInUse(inUse);
        if (isCreated) {
            record.setCreated();
        }
        return record;
    }

    private RelationshipRecord readRelationshipRecord(long id, ReadableChannel channel) throws IOException {
        RelationshipRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requiresSecondaryUnit = Bits.bitFlag((byte)flags, (byte)4);
        boolean hasSecondaryUnit = Bits.bitFlag((byte)flags, (byte)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((byte)flags, (byte)16);
        if (inUse) {
            record = new RelationshipRecord(id);
            record.setLinks(channel.getLong(), channel.getLong(), channel.getInt());
            record.setInUse(true);
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            byte extraByte = channel.get();
            record.setFirstInFirstChain((extraByte & 1) > 0);
            record.setFirstInSecondChain((extraByte & 2) > 0);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new RelationshipRecord(id);
            record.setLinks(-1L, -1L, channel.getInt());
            record.setInUse(false);
        }
        if (Bits.bitFlag((byte)flags, (byte)2)) {
            record.setCreated();
        }
        return record;
    }

    private DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & 0x20) != 0);
            if ((inUseFlag & 2) != 0) {
                record.setCreated();
            }
            int nrOfBytes = channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private <T> int readDynamicRecords(ReadableChannel channel, T target, CommandReading.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = this.readDynamicRecord(channel);
            if (read == null) {
                return -1;
            }
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        PropertyRecord record = new PropertyRecord(id);
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean nodeProperty = !Bits.bitFlag((byte)flags, (byte)Record.REL_PROPERTY.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((byte)flags, (byte)4);
        boolean hasSecondaryUnit = Bits.bitFlag((byte)flags, (byte)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((byte)flags, (byte)16);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        long primitiveId = channel.getLong();
        if (primitiveId != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = this.readPropertyBlock(channel);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        int deletedRecords = this.readDynamicRecords(channel, record, CommandReading.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER);
        if (deletedRecords == -1) {
            return null;
        }
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = this.readDynamicRecord(channel);
            if (read == null) {
                return null;
            }
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    private PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = this.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyTypeOrThrow(blocks[0]).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + PropertyType.getPropertyTypeOrThrow(blocks[0]);
        toReturn.setValueBlocks(blocks);
        if (this.readDynamicRecords(channel, toReturn, CommandReading.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    private Command visitNodeCountsCommand(ReadableChannel channel) throws IOException {
        int labelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.NodeCountsCommand(labelId, delta);
    }

    private Command visitRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        int startLabelId = channel.getInt();
        int typeId = channel.getInt();
        int endLabelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.RelationshipCountsCommand(startLabelId, typeId, endLabelId, delta);
    }

    static void markAfterRecordAsCreatedIfCommandLooksCreated(AbstractBaseRecord before, AbstractBaseRecord after) {
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        if (!before.hasSecondaryUnitId() && after.hasSecondaryUnitId()) {
            after.setSecondaryUnitIdOnCreate(after.getSecondaryUnitId());
        }
    }
}

