/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.EntityCommandGrouper;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PropertyCommandsExtractor
extends TransactionApplier.Adapter {
    private EntityCommandGrouper<Command.NodeCommand> nodeCommands = new EntityCommandGrouper<Command.NodeCommand>(Command.NodeCommand.class, 16);
    private EntityCommandGrouper<Command.RelationshipCommand> relationshipCommands = new EntityCommandGrouper<Command.RelationshipCommand>(Command.RelationshipCommand.class, 16);
    private boolean hasUpdates;

    @Override
    public void close() {
        this.nodeCommands = null;
        this.relationshipCommands = null;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.nodeCommands.add(command);
        if (!this.hasUpdates && PropertyCommandsExtractor.mayResultInIndexUpdates(command)) {
            this.hasUpdates = true;
        }
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.relationshipCommands.add(command);
        this.hasUpdates = true;
        return false;
    }

    private static boolean mayResultInIndexUpdates(Command.NodeCommand command) {
        long after;
        long before = ((NodeRecord)command.getBefore()).getLabelField();
        return before != (after = ((NodeRecord)command.getAfter()).getLabelField()) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(after);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (((PropertyRecord)command.getAfter()).isNodeSet()) {
            this.nodeCommands.add(command);
            this.hasUpdates = true;
        } else if (((PropertyRecord)command.getAfter()).isRelSet()) {
            this.relationshipCommands.add(command);
            this.hasUpdates = true;
        }
        return false;
    }

    public boolean containsAnyEntityOrPropertyUpdate() {
        return this.hasUpdates;
    }

    public EntityCommandGrouper.Cursor getNodeCommands() {
        return this.nodeCommands.sortAndAccessGroups();
    }

    public EntityCommandGrouper.Cursor getRelationshipCommands() {
        return this.relationshipCommands.sortAndAccessGroups();
    }
}

