/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class PropertyCreator {
    private final DynamicRecordAllocator stringRecordAllocator;
    private final DynamicRecordAllocator arrayRecordAllocator;
    private final IdSequence propertyRecordIdGenerator;
    private final PropertyTraverser traverser;
    private final boolean allowStorePointsAndTemporal;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;

    public PropertyCreator(PropertyStore propertyStore, PropertyTraverser traverser, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this(propertyStore.getStringStore(), propertyStore.getArrayStore(), propertyStore, traverser, propertyStore.allowStorePointsAndTemporal(), cursorTracer, memoryTracker);
    }

    PropertyCreator(DynamicRecordAllocator stringRecordAllocator, DynamicRecordAllocator arrayRecordAllocator, IdSequence propertyRecordIdGenerator, PropertyTraverser traverser, boolean allowStorePointsAndTemporal, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.stringRecordAllocator = stringRecordAllocator;
        this.arrayRecordAllocator = arrayRecordAllocator;
        this.propertyRecordIdGenerator = propertyRecordIdGenerator;
        this.traverser = traverser;
        this.allowStorePointsAndTemporal = allowStorePointsAndTemporal;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
    }

    public <P extends PrimitiveRecord> void primitiveSetProperty(RecordAccess.RecordProxy<P, ?> primitiveRecordChange, int propertyKey, Value value, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        PropertyRecord freeHost;
        PropertyBlock block = this.encodePropertyValue(propertyKey, value);
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> freeHostProxy = null;
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> existingHostProxy = null;
        long prop = primitive.getNextProp();
        while (prop != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyBlock existingBlock;
            RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> proxy = propertyRecords.getOrLoad(prop, primitive, this.cursorTracer);
            PropertyRecord propRecord = proxy.forReadingLinkage();
            assert (propRecord.inUse()) : propRecord;
            if (propRecord.hasSpaceFor(block)) {
                freeHostProxy = proxy;
                if (existingHostProxy != null) {
                    PropertyRecord freeHost2 = proxy.forChangingData();
                    freeHost2.addPropertyBlock(block);
                    freeHost2.setChanged(primitive);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
            }
            if ((existingBlock = propRecord.getPropertyBlock(propertyKey)) != null) {
                existingHostProxy = proxy;
                PropertyRecord existingHost = existingHostProxy.forChangingData();
                this.removeProperty(primitive, existingHost, existingBlock);
                if (block.getSize() <= existingBlock.getSize() || existingHost.hasSpaceFor(block)) {
                    existingHost.addPropertyBlock(block);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
                if (freeHostProxy != null) {
                    PropertyRecord freeHost3 = freeHostProxy.forChangingData();
                    freeHost3.addPropertyBlock(block);
                    freeHost3.setChanged(primitive);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
            }
            prop = propRecord.getNextProp();
        }
        if (freeHostProxy == null) {
            freeHost = propertyRecords.create(this.propertyRecordIdGenerator.nextId(this.cursorTracer), primitive, this.cursorTracer).forChangingData();
            freeHost.setInUse(true);
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = propertyRecords.getOrLoad(primitive.getNextProp(), primitive, this.cursorTracer).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(freeHost.getId());
                freeHost.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(freeHost.getId());
        } else {
            freeHost = (PropertyRecord)freeHostProxy.forChangingData();
        }
        freeHost.addPropertyBlock(block);
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    private void removeProperty(PrimitiveRecord primitive, PropertyRecord host, PropertyBlock block) {
        host.removePropertyBlock(block.getKeyIndexId());
        host.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            host.addDeletedRecord(record);
        }
    }

    public PropertyBlock encodePropertyValue(int propertyKey, Value value) {
        return this.encodeValue(new PropertyBlock(), propertyKey, value);
    }

    public PropertyBlock encodeValue(PropertyBlock block, int propertyKey, Value value) {
        PropertyStore.encodeValue(block, propertyKey, value, this.stringRecordAllocator, this.arrayRecordAllocator, this.allowStorePointsAndTemporal, this.cursorTracer, this.memoryTracker);
        return block;
    }

    public long createPropertyChain(PrimitiveRecord owner, Iterator<PropertyBlock> properties, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        return this.createPropertyChain(owner, properties, propertyRecords, p -> {});
    }

    private long createPropertyChain(PrimitiveRecord owner, Iterator<PropertyBlock> properties, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, Consumer<PropertyRecord> createdPropertyRecords) {
        if (properties == null || !properties.hasNext()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        PropertyRecord currentRecord = propertyRecords.create(this.propertyRecordIdGenerator.nextId(this.cursorTracer), owner, this.cursorTracer).forChangingData();
        createdPropertyRecords.accept(currentRecord);
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        PropertyRecord firstRecord = currentRecord;
        while (properties.hasNext()) {
            PropertyBlock block = properties.next();
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = this.propertyRecordIdGenerator.nextId(this.cursorTracer);
                currentRecord = propertyRecords.create(propertyId, owner, this.cursorTracer).forChangingData();
                createdPropertyRecords.accept(currentRecord);
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
            }
            currentRecord.addPropertyBlock(block);
        }
        return firstRecord.getId();
    }
}

