/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.EntityCommandGrouper;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.values.storable.Value;

public class PropertyPhysicalToLogicalConverter {
    private static final Comparator<PropertyBlock> BLOCK_COMPARATOR = Comparator.comparingInt(PropertyBlock::getKeyIndexId);
    private final PropertyStore propertyStore;
    private final PageCursorTracer cursorTracer;
    private PropertyBlock[] beforeBlocks = new PropertyBlock[8];
    private int beforeBlocksCursor;
    private PropertyBlock[] afterBlocks = new PropertyBlock[8];
    private int afterBlocksCursor;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore, PageCursorTracer cursorTracer) {
        this.propertyStore = propertyStore;
        this.cursorTracer = cursorTracer;
    }

    public void convertPropertyRecord(EntityCommandGrouper.Cursor changes, EntityUpdates.Builder properties) {
        this.mapBlocks(changes);
        int bc = 0;
        int ac = 0;
        while (bc < this.beforeBlocksCursor || ac < this.afterBlocksCursor) {
            int key;
            PropertyBlock beforeBlock = null;
            PropertyBlock afterBlock = null;
            int beforeKey = Integer.MAX_VALUE;
            int afterKey = Integer.MAX_VALUE;
            if (bc < this.beforeBlocksCursor) {
                beforeBlock = this.beforeBlocks[bc];
                beforeKey = beforeBlock.getKeyIndexId();
            }
            if (ac < this.afterBlocksCursor) {
                afterBlock = this.afterBlocks[ac];
                afterKey = afterBlock.getKeyIndexId();
            }
            if (beforeKey < afterKey) {
                afterBlock = null;
                key = beforeKey;
                ++bc;
            } else if (beforeKey > afterKey) {
                beforeBlock = null;
                key = afterKey;
                ++ac;
            } else {
                key = afterKey;
                ++bc;
                ++ac;
            }
            if (beforeBlock != null && afterBlock != null) {
                if (beforeBlock.hasSameContentsAs(afterBlock)) continue;
                Value beforeVal = this.valueOf(beforeBlock);
                Value afterVal = this.valueOf(afterBlock);
                properties.changed(key, beforeVal, afterVal);
                continue;
            }
            if (afterBlock != null) {
                properties.added(key, this.valueOf(afterBlock));
                continue;
            }
            properties.removed(key, this.valueOf(beforeBlock));
        }
    }

    private void mapBlocks(EntityCommandGrouper.Cursor changes) {
        Command.PropertyCommand change;
        this.beforeBlocksCursor = 0;
        this.afterBlocksCursor = 0;
        while ((change = changes.nextProperty()) != null) {
            for (PropertyBlock block : (PropertyRecord)change.getBefore()) {
                if (this.beforeBlocksCursor == this.beforeBlocks.length) {
                    this.beforeBlocks = Arrays.copyOf(this.beforeBlocks, this.beforeBlocksCursor * 2);
                }
                this.beforeBlocks[this.beforeBlocksCursor++] = block;
            }
            for (PropertyBlock block : (PropertyRecord)change.getAfter()) {
                if (this.afterBlocksCursor == this.afterBlocks.length) {
                    this.afterBlocks = Arrays.copyOf(this.afterBlocks, this.afterBlocksCursor * 2);
                }
                this.afterBlocks[this.afterBlocksCursor++] = block;
            }
        }
        Arrays.sort(this.beforeBlocks, 0, this.beforeBlocksCursor, BLOCK_COMPARATOR);
        Arrays.sort(this.afterBlocks, 0, this.afterBlocksCursor, BLOCK_COMPARATOR);
    }

    private Value valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().value(block, this.propertyStore, this.cursorTracer);
    }
}

