/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.storageengine.api.LogVersionRepository;

public class ReadOnlyLogVersionRepository
implements LogVersionRepository {
    private static final int NOT_EXISTING_VERSION = 0;
    private final FixedLogVersion logVersion;
    private final FixedLogVersion checkpointLogVersion;

    public ReadOnlyLogVersionRepository(PageCache pageCache, DatabaseLayout databaseLayout, PageCursorTracer cursorTracer) throws IOException {
        this.logVersion = new FixedLogVersion(ReadOnlyLogVersionRepository.readLogVersion(pageCache, databaseLayout.metadataStore(), cursorTracer, MetaDataStore.Position.LOG_VERSION));
        this.checkpointLogVersion = new FixedLogVersion(ReadOnlyLogVersionRepository.readLogVersion(pageCache, databaseLayout.metadataStore(), cursorTracer, MetaDataStore.Position.CHECKPOINT_LOG_VERSION));
    }

    public long getCurrentLogVersion() {
        return this.getCurrentVersion(this.logVersion);
    }

    public void setCurrentLogVersion(long version, PageCursorTracer cursorTracer) {
        this.setCurrentVersionAttempt();
    }

    public long incrementAndGetVersion(PageCursorTracer cursorTracer) {
        return this.incrementAndGetVersion(this.logVersion);
    }

    public long getCheckpointLogVersion() {
        return this.getCurrentVersion(this.checkpointLogVersion);
    }

    public void setCheckpointLogVersion(long version, PageCursorTracer cursorTracer) {
        this.setCurrentVersionAttempt();
    }

    public long incrementAndGetCheckpointLogVersion(PageCursorTracer cursorTracer) {
        return this.incrementAndGetVersion(this.checkpointLogVersion);
    }

    private long getCurrentVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository has observed a call to incrementVersion, which indicates that it's been shut down");
        }
        return version.getValue();
    }

    private void setCurrentVersionAttempt() {
        throw new UnsupportedOperationException("Can't set current log version in read only version repository.");
    }

    private long incrementAndGetVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository only allows to call incrementVersion once, during shutdown");
        }
        version.setIncrementAttempt();
        return version.getValue();
    }

    private static long readLogVersion(PageCache pageCache, Path neoStore, PageCursorTracer cursorTracer, MetaDataStore.Position position) throws IOException {
        try {
            long logVersion = MetaDataStore.getRecord(pageCache, neoStore, position, cursorTracer);
            return logVersion != -1L ? logVersion : 0L;
        }
        catch (NoSuchFileException ignore) {
            return 0L;
        }
    }

    private static class FixedLogVersion {
        private boolean incrementAttempt;
        private final long value;

        FixedLogVersion(long value) {
            this.value = value;
        }

        boolean isIncrementAttempted() {
            return this.incrementAttempt;
        }

        long getValue() {
            return this.value;
        }

        void setIncrementAttempt() {
            this.incrementAttempt = true;
        }
    }
}

