/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final int transactionChecksum;
    private final long logVersion;
    private final long byteOffset;

    public ReadOnlyTransactionIdStore(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, PageCursorTracer cursorTracer) throws IOException {
        long id = 0L;
        int checksum = 0;
        long logVersion = 0L;
        long byteOffset = 0L;
        if (NeoStores.isStorePresent(fs, databaseLayout)) {
            Path neoStore = databaseLayout.metadataStore();
            id = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID, cursorTracer);
            checksum = (int)MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, cursorTracer);
            logVersion = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, cursorTracer);
            byteOffset = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, cursorTracer);
        }
        this.transactionId = id;
        this.transactionChecksum = checksum;
        this.logVersion = logVersion;
        this.byteOffset = byteOffset;
    }

    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long committingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum, 0L);
    }

    public TransactionId getUpgradeTransaction() {
        return this.getLastCommittedTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    public long[] getLastClosedTransaction() {
        return new long[]{this.transactionId, this.logVersion, this.byteOffset};
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long logByteOffset, long logVersion, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionClosed(long transactionId, long logVersion, long logByteOffset, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void flush(PageCursorTracer cursorTracer) {
    }
}

