/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.LocalIntCounter;

public class RecordChanges<RECORD, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> recordChanges;
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final MutableInt changeCounter;

    public RecordChanges(RecordAccess.Loader<RECORD, ADDITIONAL> loader, MutableInt globalCounter, MemoryTracker memoryTracker) {
        this.loader = loader;
        this.recordChanges = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
        this.changeCounter = new LocalIntCounter(globalCounter);
    }

    public String toString() {
        return "RecordChanges{recordChanges=" + this.recordChanges + "}";
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return (RecordAccess.RecordProxy)this.recordChanges.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        RecordChange<RECORD, ADDITIONAL> result = (RecordChange<RECORD, ADDITIONAL>)this.recordChanges.get(key);
        if (result == null) {
            RECORD record = this.loader.load(key, additionalData, cursorTracer);
            result = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData, cursorTracer);
        }
        return result;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        RecordChange<RECORD, ADDITIONAL> recordChange = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData, cursorTracer);
        this.recordChanges.put(key, recordChange);
        return recordChange;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<RECORD, ADDITIONAL> change = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, true, additionalData, cursorTracer);
        this.recordChanges.put(key, change);
        return change;
    }

    @Override
    public Collection<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> changes() {
        return this.recordChanges.values();
    }

    public static class RecordChange<RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges;
        private final MutableInt changeCounter;
        private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
        private final ADDITIONAL additionalData;
        private final PageCursorTracer cursorTracer;
        private final RECORD record;
        private final boolean created;
        private final long key;
        private RECORD before;
        private boolean changed;

        public RecordChange(MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges, MutableInt changeCounter, long key, RECORD record, RecordAccess.Loader<RECORD, ADDITIONAL> loader, boolean created, ADDITIONAL additionalData, PageCursorTracer cursorTracer) {
            this.allChanges = allChanges;
            this.changeCounter = changeCounter;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.created = created;
            this.additionalData = additionalData;
            this.cursorTracer = cursorTracer;
        }

        public String toString() {
            return "RecordChange{record=" + this.record + ",key=" + this.key + ",created=" + this.created + "}";
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy(this.cursorTracer);
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                RecordAccess.RecordProxy previous = (RecordAccess.RecordProxy)this.allChanges.put(this.key, (Object)this);
                if (previous == null || !previous.isChanged()) {
                    this.changeCounter.increment();
                }
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy(PageCursorTracer cursorTracer) {
            if (!this.created) {
                this.loader.ensureHeavy(this.record, cursorTracer);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before, cursorTracer);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy(this.cursorTracer);
            return this.record;
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.loader.copy(this.record);
            }
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

