/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.nio.ByteBuffer;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.common.EntityType;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class RecordPropertyCursor
extends PropertyRecord
implements StoragePropertyCursor {
    private static final int MAX_BYTES_IN_SHORT_STRING_OR_SHORT_ARRAY = 32;
    private static final int INITIAL_POSITION = -1;
    public static final int DEFAULT_PROPERTY_BUFFER_CAPACITY = 512;
    private final PropertyStore propertyStore;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;
    private long next;
    private int block;
    private ScopedBuffer scopedBuffer;
    private ByteBuffer buffer;
    private PageCursor page;
    private PageCursor stringPage;
    private PageCursor arrayPage;
    private boolean open;
    private int numSeenPropertyRecords;
    private long first;
    private long ownerReference;
    private MutableLongSet cycleDetection;
    private EntityType ownerEntityType;
    private RecordLoadOverride loadMode;

    RecordPropertyCursor(PropertyStore propertyStore, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        super(-1L);
        this.propertyStore = propertyStore;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
        this.loadMode = RecordLoadOverride.none();
    }

    public void initNodeProperties(long reference, long ownerReference) {
        this.init(reference, ownerReference, EntityType.NODE);
    }

    public void initRelationshipProperties(long reference, long ownerReference) {
        this.init(reference, ownerReference, EntityType.RELATIONSHIP);
    }

    private void init(long reference, long ownerReference, EntityType ownerEntityType) {
        if (this.getId() != -1L) {
            this.clear();
        }
        this.block = Integer.MAX_VALUE;
        this.ownerReference = ownerReference;
        this.ownerEntityType = ownerEntityType;
        if (reference != -1L && this.page == null) {
            this.page = this.propertyPage(reference);
        }
        this.next = reference;
        this.first = reference;
        this.numSeenPropertyRecords = 0;
        this.cycleDetection = null;
        this.open = true;
    }

    public boolean next() {
        while (true) {
            block7: {
                int numberOfBlocks;
                block9: {
                    block8: {
                        if (this.block >= (numberOfBlocks = this.getNumberOfBlocks())) break block7;
                        if (this.block != -1) break block8;
                        this.block = 0;
                        break block9;
                    }
                    long current = this.currentBlock();
                    PropertyType type = PropertyType.getPropertyTypeOrNull(current);
                    if (type == null) break block7;
                    this.block += type.calculateNumberOfBlocksUsed(current);
                }
                if (this.block < numberOfBlocks && this.type() != null) {
                    return true;
                }
            }
            if (this.next == -1L) {
                return false;
            }
            this.property(this, this.next, this.page);
            this.next = this.getNextProp();
            this.block = -1;
            if (++this.numSeenPropertyRecords < 100000) continue;
            if (this.cycleDetection == null) {
                this.cycleDetection = LongSets.mutable.empty();
            }
            if (!this.cycleDetection.add(this.next)) break;
        }
        throw new InconsistentDataReadException("Aborting property reading due to detected chain cycle, starting at property record id:%d from owner %s:%d", this.first, this.ownerEntityType, this.ownerReference);
    }

    private long currentBlock() {
        return this.getBlocks()[this.block];
    }

    public void reset() {
        if (this.open) {
            this.open = false;
            this.loadMode = RecordLoadOverride.none();
            this.clear();
            this.numSeenPropertyRecords = 0;
            this.first = -1L;
            this.ownerReference = -1L;
            this.cycleDetection = null;
        }
    }

    public void setForceLoad() {
        this.loadMode = RecordLoadOverride.FORCE;
    }

    public int propertyKey() {
        return PropertyBlock.keyIndexId(this.currentBlock());
    }

    public ValueGroup propertyType() {
        PropertyType type = this.type();
        if (type == null) {
            return ValueGroup.NO_VALUE;
        }
        switch (type) {
            case BOOL: {
                return ValueGroup.BOOLEAN;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ValueGroup.NUMBER;
            }
            case STRING: 
            case CHAR: 
            case SHORT_STRING: {
                return ValueGroup.TEXT;
            }
            case TEMPORAL: 
            case GEOMETRY: 
            case SHORT_ARRAY: 
            case ARRAY: {
                return this.propertyValue().valueGroup();
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    private PropertyType type() {
        return PropertyType.getPropertyTypeOrNull(this.currentBlock());
    }

    public Value propertyValue() {
        try {
            return this.readValue();
        }
        catch (InconsistentDataReadException | InvalidRecordException e) {
            throw new InconsistentDataReadException((Throwable)e, "Unable to read property value in record:%d, starting at property record id:%d from owner %s:%d", this.getId(), this.first, this.ownerEntityType, this.ownerReference);
        }
    }

    private Value readValue() {
        PropertyType type = this.type();
        if (type == null) {
            return Values.NO_VALUE;
        }
        switch (type) {
            case BOOL: {
                return this.readBoolean();
            }
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return this.readFloat();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return this.readChar();
            }
            case SHORT_STRING: {
                return this.readShortString();
            }
            case SHORT_ARRAY: {
                return this.readShortArray();
            }
            case STRING: {
                return this.readLongString();
            }
            case ARRAY: {
                return this.readLongArray();
            }
            case GEOMETRY: {
                return this.geometryValue();
            }
            case TEMPORAL: {
                return this.temporalValue();
            }
        }
        throw new IllegalStateException("Unsupported PropertyType: " + type.name());
    }

    private Value geometryValue() {
        return GeometryType.decode(this.getBlocks(), this.block);
    }

    private Value temporalValue() {
        return TemporalType.decode(this.getBlocks(), this.block);
    }

    private ArrayValue readLongArray() {
        long reference = PropertyBlock.fetchLong(this.currentBlock());
        if (this.arrayPage == null) {
            this.arrayPage = this.arrayPage(reference);
        }
        return this.array(this, reference, this.arrayPage);
    }

    private TextValue readLongString() {
        long reference = PropertyBlock.fetchLong(this.currentBlock());
        if (this.stringPage == null) {
            this.stringPage = this.stringPage(reference);
        }
        return this.string(this, reference, this.stringPage);
    }

    private Value readShortArray() {
        Bits bits = Bits.bits((int)32);
        int blocksUsed = ShortArray.calculateNumberOfBlocksUsed(this.currentBlock());
        for (int i = 0; i < blocksUsed; ++i) {
            bits.put(this.getBlocks()[this.block + i]);
        }
        return ShortArray.decode(bits);
    }

    private TextValue readShortString() {
        return LongerShortString.decode(this.getBlocks(), this.block);
    }

    private TextValue readChar() {
        return Values.charValue((char)((char)PropertyBlock.fetchShort(this.currentBlock())));
    }

    private DoubleValue readDouble() {
        return Values.doubleValue((double)Double.longBitsToDouble(this.getBlocks()[this.block + 1]));
    }

    private FloatValue readFloat() {
        return Values.floatValue((float)Float.intBitsToFloat(PropertyBlock.fetchInt(this.currentBlock())));
    }

    private LongValue readLong() {
        if (PropertyBlock.valueIsInlined(this.currentBlock())) {
            return Values.longValue((long)(PropertyBlock.fetchLong(this.currentBlock()) >>> 1));
        }
        return Values.longValue((long)this.getBlocks()[this.block + 1]);
    }

    private IntValue readInt() {
        return Values.intValue((int)PropertyBlock.fetchInt(this.currentBlock()));
    }

    private ShortValue readShort() {
        return Values.shortValue((short)PropertyBlock.fetchShort(this.currentBlock()));
    }

    private ByteValue readByte() {
        return Values.byteValue((byte)PropertyBlock.fetchByte(this.currentBlock()));
    }

    private BooleanValue readBoolean() {
        return Values.booleanValue((PropertyBlock.fetchByte(this.currentBlock()) == 1 ? 1 : 0) != 0);
    }

    @Override
    public PropertyRecord copy() {
        throw new UnsupportedOperationException("Record cursors are not copyable.");
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.getId() + ", open state with: block=" + this.block + ", next=" + this.next + ", underlying record=" + super.toString() + "]";
    }

    public void close() {
        if (this.stringPage != null) {
            this.stringPage.close();
            this.stringPage = null;
        }
        if (this.arrayPage != null) {
            this.arrayPage.close();
            this.arrayPage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
        if (this.scopedBuffer != null) {
            this.scopedBuffer.close();
            this.scopedBuffer = null;
            this.buffer = null;
        }
    }

    private PageCursor propertyPage(long reference) {
        return this.propertyStore.openPageCursorForReading(reference, this.cursorTracer);
    }

    private PageCursor stringPage(long reference) {
        return this.propertyStore.openStringPageCursor(reference, this.cursorTracer);
    }

    private PageCursor arrayPage(long reference) {
        return this.propertyStore.openArrayPageCursor(reference, this.cursorTracer);
    }

    private void property(PropertyRecord record, long reference, PageCursor pageCursor) {
        this.propertyStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.ALWAYS), pageCursor);
    }

    private TextValue string(RecordPropertyCursor cursor, long reference, PageCursor page) {
        this.propertyStore.loadString(reference, cursor, page, this.loadMode.orElse(RecordLoad.ALWAYS));
        this.buffer.flip();
        byte[] bytes = new byte[this.buffer.limit()];
        this.buffer.get(bytes);
        return Values.utf8Value((byte[])bytes);
    }

    private ArrayValue array(RecordPropertyCursor cursor, long reference, PageCursor page) {
        this.propertyStore.loadArray(reference, cursor, page, this.loadMode.orElse(RecordLoad.ALWAYS));
        this.buffer.flip();
        return PropertyStore.readArrayFromBuffer(this.buffer);
    }

    public void setScopedBuffer(ScopedBuffer scopedBuffer) {
        this.scopedBuffer = scopedBuffer;
        this.buffer = scopedBuffer.getBuffer();
    }

    public ByteBuffer getOrCreateClearBuffer() {
        if (this.buffer == null) {
            this.setScopedBuffer((ScopedBuffer)new HeapScopedBuffer(512, this.memoryTracker));
        } else {
            this.buffer.clear();
        }
        return this.buffer;
    }

    public ByteBuffer growBuffer(int minAdditionalCapacity) {
        this.buffer.flip();
        int oldCapacity = this.buffer.capacity();
        int newCapacity = Math.max(oldCapacity, minAdditionalCapacity) + oldCapacity;
        ScopedBuffer oldScopedBuffer = this.scopedBuffer;
        this.setScopedBuffer((ScopedBuffer)new HeapScopedBuffer(newCapacity, this.memoryTracker));
        this.buffer.put(oldScopedBuffer.getBuffer());
        oldScopedBuffer.close();
        return this.buffer;
    }
}

